*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          NFVMANOLogManagementKeywords.robot
Library           JSONLibrary
Library           OperatingSystem
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false

*** Test Cases ***
POST Create a new logging job
    [Documentation]    Test ID: 8.3.4.1.1
    ...    Test title: POST Create a new logging job
    ...    Test objective: The objective is to create a new logging job, and perform the JSON schema validation of the operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: logging job created
    POST Create a new logging job
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    LoggingJob
    Check Post-Condition Logging job is created
    
GET information about logging jobs 
    [Documentation]    Test ID: 8.3.4.1.2
    ...    Test title: GET information logging jobs
    ...    Test objective: The objective is to retrieve information about logging jobs, and perform the JSON schema validation of the operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    GET Logging Jobs
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
    
GET Logging jobs - invalid attribute-based filter
    [Documentation]    Test ID: 8.3.4.1.3
    ...    Test title: GET Logging jobs - invalid attribute-based filter
    ...    Test objective:  The objective is to test that the retrieval of logging jobs fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Job with invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails   
    
GET Logging jobs - invalid attribute selector
    [Documentation]    Test ID: 8.3.4.1.4
    ...    Test title: GET Logging jobs - invalid attribute selector
    ...    Test objective: The objective is to test that the retrieval of logging jobs fails when using invalid attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Job with invalid selector
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails  
    
GET Logging jobs - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.4.1.5
    ...    Test title: GET Logging jobs - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of Logging job fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
     GET Logging Jobs
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails 

GET information about logging jobs with attribute-based filter
    [Documentation]    Test ID: 8.3.4.1.6
    ...    Test title: GET information about logging jobs with attribute-based filter
    ...    Test objective: The objective is to retrieve information about the logging jobs with attribute filters, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Job with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
    
GET information about logging jobs with "all_fields" attribute selector
    [Documentation]    Test ID: 8.3.4.1.7
    ...    Test title: GET information about logging jobs with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve information about logging jobs with "all_fields" attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging jobs with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
    
GET information about Logging Jobs with "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.4.1.8
    ...    Test title: GET information about Logging Jobs with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve information about logging jobs with "exclude_default" attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Jobs with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs

GET information about Logging Jobs with "fields" attribute selector
    [Documentation]    Test ID: 8.3.4.1.9
    ...    Test title: GET information about Logging Jobs with fields attribute selector
    ...    Test objective: The objective is to retrieve information about Logging Jobs with fields attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Jobs with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
     
GET information about Logging Jobs with "exclude_fields" attribute selector
    [Documentation]    Test ID: 8.3.4.1.10
    ...    Test title: GET information about Logging Jobs with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve information about the Logging Jobs with "exclude_fields" attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Jobs with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
    
GET information about Logging Jobs with "fields" and "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.4.1.11
    ...    Test title: GET information about Logging Jobs with fields and exclude_default attribute selector
    ...    Test objective: The objective is to retrieve information about Logging Jobs with fields and exclude_default attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Jobs with fields and exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LoggingJobs
    
GET information about Logging Jobs with Paged Response
    [Documentation]    Test ID: 8.3.4.1.12
    ...    Test title: GET information about Logging Jobs with Paged Response
    ...    Test objective: The objective is to query information about Logging Jobs to get Paged Response.
    ...    Pre-conditions:  At least one logging job is created.
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Logging Jobs
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
GET information about Logging Jobs with malformed authorization token
    [Documentation]    Test ID: 8.3.1.8.13
    ...    Test title: GET information about Logging Jobs with malformed authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Logging Jobs fails when using malformed authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Logging Jobs with malformed authorization token
    Check HTTP Response Status Code Is    401

GET information about Logging Jobs without authorization token
    [Documentation]    Test ID: 8.3.4.1.14
    ...    Test title: GET information about Logging Jobs without authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Logging Jobs fails when omitting the authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Logging Jobs without authorization token
    Check HTTP Response Status Code Is    401

GET information about Logging Jobs with expired or revoked authorization token
    [Documentation]    Test ID: 8.3.4.1.15
    ...    Test title: GET information about Logging Jobs with expired or revoked authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Logging Jobs fails when using expired or revoked authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.2 - ETSI GS NFV-SOL 009 [5] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Logging Jobs with expired or revoked authorization token
    Check HTTP Response Status Code Is    401

PUT Logging Jobs - Method not implemented
    [Documentation]    Test ID: 8.3.4.1.13
    ...    Test title: PUT Logging Jobs - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Logging Jobs
    Check HTTP Response Status Code Is    405

PATCH Logging Jobs - Method not implemented
    [Documentation]    Test ID: 8.3.4.1.14
    ...    Test title: PATCH Logging Jobs - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Logging Jobs
    Check HTTP Response Status Code Is    405

DELETE Logging Jobs - Method not implemented
    [Documentation]    Test ID: 8.3.4.1.15
    ...    Test title: DELETE Logging Jobs - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.3.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Logging Jobs
    Check HTTP Response Status Code Is    405