*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Scale a vnfInstance to level
    [Documentation]    Test ID: 6.3.5.5.1
    ...    Test title: POST Scale a vnfInstance to level
    ...    Test objective: The objective is to scale a VNF instance to a target level.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.6.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Scale vnfInstance to level     
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id

POST Scale a vnfInstance to level Conflict (Not-Instantiated)
    [Documentation]    Test ID: 6.3.5.5.2
    ...    Test title: POST Scale a vnfInstance to level Conflict (Not-Instantiated)
    ...    Test objective: The objective is to verify that the operation cannot be executed currently, due to a conflict with the state of the VNF instance resource or that a required child attribute of the "extensions" attribue has not been set. 
    ...    Pre-conditions: VNF instance resource is in NOT-INSTANTIATED state
    ...    Reference: Clause 5.4.6.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Scale vnfInstance to level   
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Scale a vnfInstance Not Found
    [Documentation]    Test ID: 6.3.5.5.3
    ...    Test title: POST Scale a vnfInstance Not Found
    ...    Test objective: The objective is to verify that the VNF Scale operation fails when the VNF instance resource is not present
    ...    Pre-conditions: VNF instance resource is in NOT-INSTANTIATED state
    ...    Reference: Clause 5.4.6.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none 
    ...    Post-Conditions: none
    POST Scale vnfInstance to level    
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails 
       
GET Scale to level VNFInstance - Method not implemented
    [Documentation]    Test ID: 6.3.5.5.4
    ...    Test title: GET Scale to level VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.6.3.2 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Scale vnfInstance to level
    Check HTTP Response Status Code Is    405

PUT Scale to level VNFInstance - Method not implemented
    [Documentation]    Test ID: 6.3.5.5.5
    ...    Test title: PUT Scale to level VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.6.3.3 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Scale vnfInstance to level
    Check HTTP Response Status Code Is    405

PATCH Scale to level VNFInstance - Method not implemented
    [Documentation]    Test ID: 6.3.5.5.6
    ...    Test title: PATCH Scale to level VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.6.3.4 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Scale vnfInstance to level
    Check HTTP Response Status Code Is    405
    
DELETE Scale to level VNFInstance - Method not implemented
    [Documentation]    Test ID: 6.3.5.5.7
    ...    Test title: DELETE Scale to level VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.6.3.5 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Scale vnfInstance to level
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200