/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.MediaType;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.JsonBody;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;

public abstract class BodyWithContentTypeDTO
extends BodyDTO {
    protected String contentType;

    public BodyWithContentTypeDTO(Body.Type type, Boolean not, String contentType) {
        super(type, not);
        this.contentType = contentType;
    }

    public static BodyWithContentTypeDTO createDTO(BodyWithContentType body) {
        BodyWithContentTypeDTO result = null;
        if (body instanceof BinaryBody) {
            BinaryBody binaryBody = (BinaryBody)body;
            result = new BinaryBodyDTO(binaryBody, binaryBody.getNot());
        } else if (body instanceof JsonBody) {
            JsonBody jsonBody = (JsonBody)body;
            result = new JsonBodyDTO(jsonBody, jsonBody.getNot());
        } else if (body instanceof ParameterBody) {
            ParameterBody parameterBody = (ParameterBody)body;
            result = new ParameterBodyDTO(parameterBody, parameterBody.getNot());
        } else if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            result = new StringBodyDTO(stringBody, stringBody.getNot());
        } else if (body instanceof XmlBody) {
            XmlBody xmlBody = (XmlBody)body;
            result = new XmlBodyDTO(xmlBody, xmlBody.getNot());
        }
        return result;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public abstract BodyWithContentType buildObject();

    @JsonIgnore
    MediaType getMediaType() {
        return this.contentType != null ? MediaType.parse(this.contentType) : null;
    }
}

