/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class KeysToMultiValues<T extends KeyToMultiValue, K extends KeysToMultiValues>
extends ObjectWithJsonToString {
    private ListMultimap<NottableString, NottableString> listMultimap = Multimaps.synchronizedListMultimap(LinkedListMultimap.create());

    public CaseInsensitiveRegexMultiMap toCaseInsensitiveRegexMultiMap(List<T> entries) {
        CaseInsensitiveRegexMultiMap caseInsensitiveRegexMultiMap = new CaseInsensitiveRegexMultiMap();
        if (entries != null) {
            for (KeyToMultiValue keyToMultiValue : entries) {
                for (NottableString value : keyToMultiValue.getValues()) {
                    caseInsensitiveRegexMultiMap.put(keyToMultiValue.getName(), value);
                }
            }
        }
        return caseInsensitiveRegexMultiMap;
    }

    public abstract T build(NottableString var1, List<NottableString> var2);

    public K withEntries(Map<String, List<String>> entries) {
        this.listMultimap.clear();
        for (String name : entries.keySet()) {
            for (String value : entries.get(name)) {
                this.withEntry(name, value);
            }
        }
        return (K)this;
    }

    public K withEntries(List<T> entries) {
        this.listMultimap.clear();
        if (entries != null) {
            for (KeyToMultiValue entry : entries) {
                this.withEntry(entry);
            }
        }
        return (K)this;
    }

    @SafeVarargs
    public final K withEntries(T ... entries) {
        if (ArrayUtils.isNotEmpty(entries)) {
            this.withEntries(Arrays.asList(entries));
        }
        return (K)this;
    }

    public K withEntry(T entry) {
        if (((KeyToMultiValue)entry).getValues().isEmpty()) {
            this.listMultimap.put(((KeyToMultiValue)entry).getName(), null);
        } else {
            this.listMultimap.putAll(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return (K)this;
    }

    public K withEntry(String name, String ... values) {
        if (ArrayUtils.isNotEmpty(values)) {
            this.listMultimap.putAll(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return (K)this;
    }

    public K withEntry(NottableString name, List<NottableString> values) {
        if (values != null) {
            this.listMultimap.putAll(name, values);
        }
        return (K)this;
    }

    public K withEntry(NottableString name, NottableString ... values) {
        if (ArrayUtils.isNotEmpty(values)) {
            this.withEntry(name, Arrays.asList(values));
        }
        return (K)this;
    }

    public K remove(String name) {
        for (NottableString key : new ArrayList(this.listMultimap.keySet())) {
            if (!key.equalsIgnoreCase(name)) continue;
            this.listMultimap.removeAll(key);
        }
        return (K)this;
    }

    public K remove(NottableString name) {
        for (NottableString key : new ArrayList(this.listMultimap.keySet())) {
            if (!key.equalsIgnoreCase(name)) continue;
            this.listMultimap.removeAll(key);
        }
        return (K)this;
    }

    public K replaceEntry(T entry) {
        if (entry != null) {
            this.remove(((KeyToMultiValue)entry).getName());
            this.listMultimap.putAll(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return (K)this;
    }

    public K replaceEntry(String name, String ... values) {
        if (ArrayUtils.isNotEmpty(values)) {
            this.remove(name);
            this.listMultimap.putAll(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return (K)this;
    }

    public List<T> getEntries() {
        ArrayList<T> headers = new ArrayList<T>();
        for (NottableString nottableString : new ArrayList(this.listMultimap.keySet())) {
            headers.add(this.build(nottableString, this.listMultimap.get(nottableString)));
        }
        return headers;
    }

    public List<String> getValues(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (NottableString key : new ArrayList(this.listMultimap.keySet())) {
            if (key == null || name == null || !key.equalsIgnoreCase(name)) continue;
            values.addAll(NottableString.serialiseNottableString(this.listMultimap.get(key)));
        }
        return values;
    }

    public String getFirstValue(String name) {
        String firstEntryValue = "";
        List<String> values = this.getValues(name);
        if (!values.isEmpty()) {
            firstEntryValue = values.get(0);
        }
        return firstEntryValue;
    }

    public boolean containsEntry(String name) {
        return !this.getValues(name).isEmpty();
    }

    public boolean containsEntry(String name, String value) {
        return this.containsEntry(NottableString.string(name), NottableString.string(value));
    }

    public boolean containsEntry(NottableString name, NottableString value) {
        for (NottableString entryKey : new ArrayList(this.listMultimap.keySet())) {
            if (entryKey == null || name == null || !entryKey.equalsIgnoreCase(name) || this.listMultimap.get(entryKey) == null || value == null) continue;
            for (NottableString entryValue : new ArrayList<NottableString>(this.listMultimap.get(entryKey))) {
                if (!value.equalsIgnoreCase(entryValue)) continue;
                return true;
            }
        }
        return false;
    }

    public CaseInsensitiveRegexMultiMap toCaseInsensitiveRegexMultiMap() {
        return this.toCaseInsensitiveRegexMultiMap(this.getEntries());
    }

    public boolean isEmpty() {
        return this.listMultimap.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysToMultiValues)) {
            return false;
        }
        KeysToMultiValues that = (KeysToMultiValues)o;
        return Objects.equals(this.listMultimap, that.listMultimap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listMultimap);
    }
}

