/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.log.model.RequestLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.server.netty.codec.MockServerResponseEncoder;

@ChannelHandler.Sharable
public class EchoServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final MockServerLogger mockServerLogger;
    private final EchoServer.Error error;
    private final MockServerEventLog logFilter;
    private final EchoServer.NextResponse nextResponse;
    private final EchoServer.OnlyResponse onlyResponse;

    EchoServerHandler(MockServerLogger mockServerLogger, EchoServer.Error error, MockServerEventLog logFilter, EchoServer.NextResponse nextResponse, EchoServer.OnlyResponse onlyResponse) {
        this.mockServerLogger = mockServerLogger;
        this.error = error;
        this.logFilter = logFilter;
        this.nextResponse = nextResponse;
        this.onlyResponse = onlyResponse;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        this.mockServerLogger.trace(request, "received request:{}", request);
        this.logFilter.add(new RequestLogEntry(request));
        if (this.onlyResponse.httpResponse != null) {
            DefaultFullHttpResponse httpResponse = new MockServerResponseEncoder().encode(this.onlyResponse.httpResponse);
            ctx.writeAndFlush(httpResponse);
        } else if (!this.nextResponse.httpResponse.isEmpty()) {
            DefaultFullHttpResponse httpResponse = new MockServerResponseEncoder().encode(this.nextResponse.httpResponse.remove());
            ctx.writeAndFlush(httpResponse);
        } else {
            int length;
            HttpResponse httpResponse = HttpResponse.response().withStatusCode(request.getPath().equalsIgnoreCase("/not_found") ? HttpResponseStatus.NOT_FOUND.code() : HttpResponseStatus.OK.code()).withHeaders(request.getHeaderList());
            if (request.getBody() instanceof BodyWithContentType) {
                httpResponse.withBody((BodyWithContentType)request.getBody());
            } else {
                httpResponse.withBody(request.getBodyAsString());
            }
            int n = length = httpResponse.getBodyAsString() != null ? httpResponse.getBodyAsString().length() : 0;
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH) {
                httpResponse.replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length * 2));
            } else if (this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                httpResponse.replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length / 2));
            } else {
                httpResponse.replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length));
            }
            ctx.writeAndFlush(httpResponse);
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH || this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                ctx.close();
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

