*** Settings ***
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Resource    VnfLcmMntOperationKeywords.robot

*** Test Cases ***
Post Individual VNF LCM Operation occurrences - Method not implemented
    [Documentation]    Test ID: 7.3.1.12.1
    ...    Test title: Post Individual VNF LCM Operation occurrences - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.1 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Individual VNF LCM Operation occurrences
    Check HTTP Response Status Code Is    405
    
Get Individual VNF LCM Operation occurrences
    [Documentation]    Test ID: 7.3.1.12.2
    ...    Test title: Get Individual VNF LCM Operation occurrences
    ...    Test objective: The objective is to test that this method retrieve information about a VNF lifecycle management operation occurrence 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM Operation occurrences
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfLcmOpOcc 
    Check HTTP Response Body of Individual VNF LCM Operation occurrences content against VNF Descriptor

PUT Individual VNF LCM Operation occurrences - Method not implemented
    [Documentation]    Test ID: 7.3.1.12.3
    ...    Test title: PUT Individual VNF LCM Operation occurrences - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.3 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none  
    Put multiple VNF instances
    Check HTTP Response Status Code Is    405

PATCH Individual VNF LCM Operation occurrences - Method not implemented 
    [Documentation]    Test ID: 7.3.1.12.4
    ...    Test title: PATCH Individual VNF LCM Operation occurrences - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.4 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none      
    Patch multiple VNF instances
    Check HTTP Response Status Code Is    405
    
 DELETE Individual VNF LCM Operation occurrences - Method not implemented
    [Documentation]    Test ID: 7.3.1.12.5
    ...    Test title: DELETE Individual VNF LCM Operation occurrences - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.5 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none  
    Delete multiple VNF instances
    Check HTTP Response Status Code Is    405
    
Get Individual VNF LCM Operation occurrences - Not Found
    [Documentation]    Test ID: 7.3.1.12.6
    ...    Test title: Get Individual VNF LCM Operation occurrences - Not Found
    ...    Test objective: The objective is to test that the retrieval of VNF lifecycle management operation occurrence fails when instance is not present. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM Operation occurrences
    Check HTTP Response Status Code Is    404 
    Check HTTP Response Body Json Schema Is    ProblemDetails