*** Settings ***
Resource   environment/variables.txt 
Resource   NSLCOperationGrantingKeywords.robot
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
Requests a grant for a particular NS lifecycle operation
    [Documentation]    Test ID: 9.3.1.1.1
    ...    Test title: Requests a grant for a particular NS lifecycle operation
    ...    Test objective: The objective is to request a grant for a particular NS lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: 
    ...    Reference: Clause 7.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the NFVO.
    Send Post Request for Grant
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    Grant
    Check HTTP Response Header Contains  Location 
    Check Postcondition Grant Is Set 

Requests a grant for a particular NS lifecycle operation - Forbidden 
    [Documentation]    Test ID: 9.3.1.1.2
    ...    Test title: Requests a grant for a particular NS lifecycle operation - Forbidden 
    ...    Test objective: The objective is to request a grant for a particular NS lifecycle operation and the grant is rejected
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Request for a new Grant Forbiden Operation
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Grants - Method not implemented
    [Documentation]    Test ID: 9.3.1.1.3
    ...    Test title: GET Grants - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed for Lifecycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:   none
    Get Grants
    Check HTTP Response Status Code Is    405
    
PUT Grants - Method not implemented
     [Documentation]    Test ID: 9.3.1.1.4
    ...    Test title: PUT Grants - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed for Lifecycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.3 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Put Grants
    Check HTTP Response Status Code Is    405
    
PATCH Grants - Method not implemented
    [Documentation]    Test ID: 9.3.1.1.5
    ...    Test title: PATCH Grants - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed for Lifecycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.4 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch Grants
    Check HTTP Response Status Code Is    405
    
DELETE Grants - Method not implemented
    [Documentation]    Test ID: 9.3.1.1.6
    ...    Test title: DELETE Grants - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed for Lifecycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.5 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:  Resources are not deleted
    Delete Grants
    Check HTTP Response Status Code Is    405
    Check Postcondition Grants Exist