*** Settings ***
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot  

*** Test Cases ***
POST Individual Policy - Method not implemented
    [Documentation]    Test ID: 10.3.1.3.1
    ...    Test title: POST Individual Policy - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.4.3.1 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual Policy
    Check HTTP Response Status Code Is    405

GET Information about an individual policy - Successful
     [Documentation]    Test ID: 10.3.1.3.2
    ...    Test title: GET Information about an individual policy - Successful
    ...    Test objective: The objective is to test the retrieval of Individual Policy and perform a JSON schema validation of the returned Policy data structure.
    ...    Pre-conditions: At least one policy is available in the NFV-MANO.
    ...    Reference: Clause 5.5.4.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual Policy
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policy

GET Information about an individual policy - NOT FOUND
     [Documentation]    Test ID: 10.3.1.3.3
    ...    Test title: GET Information about an individual policy - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual policy fails when using an invalid resource identifier.
    ...    Pre-conditions: At least one individual policy is available in the NFV-MANO.
    ...    Reference: Clause 5.5.8.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual Policy with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PUT an individual policy - Method not implemented
     [Documentation]    Test ID: 10.3.1.3.4
    ...    Test title: PUT an individual policy - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.4.3.3 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Individual Policy
    Check HTTP Response Status Code Is    405

PATCH an individual policy - Successful 
     [Documentation]    Test ID: 10.3.1.3.5
    ...    Test title: PATCH an individual policy - Successful
    ...    Test objective: The objective is to test that an individual policy is modified successfully when there is no conflict using PATCH method.
    ...    Pre-conditions: There should not exist a conflict as described in Reference.
    ...    Reference: Clause 5.5.4.3.4 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual Policy
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PolicyModifications
    
PATCH an individual policy - Conflict 
     [Documentation]    Test ID: 10.3.1.3.6
    ...    Test title: PATCH an individual policy - Conflict
    ...    Test objective: The objective is to test that an individual policy is not modified when there is a conflict using PATCH method.
    ...    Pre-conditions: There exists a conflict as described in Reference.
    ...    Reference: Clause 5.5.4.3.4 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual Policy
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails


DELETE an individual policy - Successful
     [Documentation]    Test ID: 10.3.1.3.7
    ...    Test title: DELETE an individual policy - Successful
    ...    Test objective: The objective is to test that DELETE method deletes a deactivated individual policy.
    ...    Pre-conditions: The activation status of individual policy to be deleted is not set to ACTIVATED.
    ...    Reference: Clause 5.5.8.3.5 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The individual policy is not available anymore in the NFV-MANO.
    DELETE Individual Policy
    Check HTTP Response Status Code Is    204
    Check Postcondition Individual Policy is Deleted

DELETE an individual policy - CONFLICT
     [Documentation]    Test ID: 10.3.1.3.8
    ...    Test title: DELETE an individual policy - CONFLICT
    ...    Test objective: The objective is to test that DELETE method does not delete an activated individual policy.
    ...    Pre-conditions: The activation status of individual policy to be deleted is set to ACTIVATED.
    ...    Reference: Clause 5.5.8.3.5 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The individual policy is not deleted.
    DELETE Individual Policy in status ACTIVATED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails    
    Check Postcondition Individual Policy is Not Deleted