*** Settings ***
Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true
Library    Process
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot 

*** Test Cases ***
POST Create a new subscription
    [Documentation]    Test ID: 10.3.1.6.1
    ...    Test title: POST Create a new subscription
    ...    Test objective: The objective is to test that POST method creates a subscription.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.1 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Policy subscription is created.     
    POST subscriptions
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    PolicySubscription
    Check HTTP Response Header Contains    Location
    Check Postcondition Policy subscription is created
        
POST Create a new Subscription - DUPLICATION NOT ALLOWED
    [Documentation]    Test ID: 10.3.1.6.2
    ...    Test title: POST Create a new subscription - DUPLICATION NOT ALLOWED
    ...    Test objective: The objective is to test that POST method cannot create a duplicate subscription. 
    ...    Pre-conditions: A subscription shall already exist. 
    ...    Reference: Clause 5.5.7.3.1 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: Duplication is not supported by NFVMANO.
    ...    Post-Conditions: Individual subscription resource returned in the location header is available.      
    POST subscriptions NO DUPLICATION
    Check Subscription Existence
    Check HTTP Response Status Code Is    303
    Check HTTP Response Header Contains    Location
    Check Postcondition Individual Subscription Resource Returned in Location Header Is Available
    
POST Create a new Subscription - UNPROCESSABLE ENTITY
    [Documentation]    Test ID: 10.3.1.6.3
    ...    Test title: POST Create a new Subscription - UNPROCESSABLE ENTITY
    ...    Test objective: The objective is to test that correct error code is generated when data in the request body cannot be processed. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.1 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: Callback URI is not reachable by the API producer.
    ...    Post-Conditions: none     
    POST subscriptions with Invalid Request
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails
        
GET Subscriptions
    [Documentation]    Test ID: 10.3.1.6.4
    ...    Test title: GET Subscriptions
    ...    Test objective: The objective is to test that GET method retrieves the list of existing subscriptions.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions

GET Subscription - Filter
    [Documentation]    Test ID: 10.3.1.6.5
    ...    Test title: GET Subscription - Filter
    ...    Test objective: The objective is to GET the list of active subscriptions using a filter.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions with filter
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions
    
GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 10.3.1.6.6
    ...    Test title: GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to GET the list of active subscriptions using an invalid filter.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get subscriptions - invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET subscriptions - Bad Request Response too Big
    [Documentation]    Test ID: 10.3.1.6.7
    ...    Test title: GET subscriptions - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of active subscriptions list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: NFV-MANO does not support paged response.
    ...    Post-Conditions: none 
    GET Subscriptions without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET subscriptions with "all_fields" attribute selector
    [Documentation]    Test ID: 10.3.1.6.8
    ...    Test title: GET subscriptions with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "all_fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none 
    ...    Post-Conditions: none
    Get subscriptions with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions 

GET subscriptions with "exclude_default" attribute selector
    [Documentation]    Test ID: 10.3.1.6.9
    ...    Test title: GET subscriptions with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_default"s attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "fields" attribute selector
    [Documentation]    Test ID: 10.3.1.6.10
    ...    Test title: GET subscriptions with "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "exclude_fields" attribute selector
    [Documentation]    Test ID: 10.3.1.6.11
    ...    Test title: GET subscriptions with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions  
        
GET Subscriptions as Paged Response
    [Documentation]    Test ID: 10.3.1.6.12
    ...    Test title: GET Subscriptions as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing subscriptions as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: NFV-MANO supports paged response.
    ...    Post-Conditions: none    
    GET Subscriptions with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link

GET subscriptions with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 10.3.1.6.13
    ...    Test title: GET subscriptions with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_default" and "fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 5.5.7.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none 
    ...    Post-Conditions: none
    Get subscriptions with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions          
    
PUT subscriptions - Method not implemented
     [Documentation]    Test ID: 10.3.1.6.14
    ...    Test title: PUT subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify a policy management subscription.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.3 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT subscriptions
    Check HTTP Response Status Code Is    405

PATCH subscriptions - Method not implemented
    [Documentation]    Test ID: 10.3.1.6.15
    ...    Test title: PATCH subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PATCH method cannot modify a policy management subscription.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.4 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH subscriptions
    Check HTTP Response Status Code Is    405

DELETE subscriptions - Method not implemented
    [Documentation]    Test ID: 10.3.1.6.16
    ...    Test title: DELETE subscriptions - Method not implemented
    ...    Test objective: The objective is to test that DELETE method cannot delete a policy management subscription.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.7.3.5 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Subscriptions are not deleted
    DELETE subscriptions
    Check HTTP Response Status Code Is    405
    Check Postcondition Subscriptions Exist