# NFV API Conformance Test Specification (NFV-TST 010)

This repository hosts the NFV API Conformance test specification for
the APIs defined in ETSI NFV GS [SOL002](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/02.08.01_60/gs_NFV-SOL002v020801p.pdf),
[SOL003](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/02.08.01_60/gs_NFV-SOL003v020801p.pdf),
[SOL005](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/005/02.08.01_60/gs_NFV-SOL005v020801p.pdf), in their versions
v2.8.1.

More information and download is available at [DGS/NFV-TST010ed281](https://portal.etsi.org/webapp/WorkProgram/Report_WorkItem.asp?WKI_ID=63121).

## Available versions

The NFV API Conformance test specification is available in the following versions:

| TST010 Version | SOL Specifications                                                                        | API Conformance Tests                                          |
|----------------|-------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| v2.4.1         | SOL002 SOL003 SOL005 v2.4.1                                                               | [v2.4.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.4.1/) |
| v2.6.1         | SOL002 SOL003 SOL005 v2.6.1                                                               | [v2.6.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.6.1/) |
| v2.7.1         | SOL002 SOL003 SOL005 v2.7.1                                                               | [v2.7.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.7.1/)
| v2.8.1         | SOL002 SOL003 SOL005 v2.8.1                                                               | [v2.8.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.8.1/)|
| v3.3.1         | SOL002 SOL003 SOL005 v3.3.1<br>SOL009 SOL011        v3.3.1<br>SOL012               v3.4.1 | [v3.3.1](https://forge.etsi.org/rep/nfv/api-tests/tree/3.3.1/) |


## Test Specification Overview
The Test Specification is built as a collection of [Robot Framework](robotframework.org/) Test Description. [Robot Framework](robotframework.org/) is a generic test automation framework for acceptance testing and acceptance 
test-driven development.

More information at [NFV API Conformance Test Specification wiki](https://forge.etsi.org/rep/nfv/api-tests/wikis/NFV-API-Conformance-Test-Specification).

## How to raise issues

Please report errors, bugs or other issues [here](https://forge.etsi.org/rep/nfv/api-tests/issues).

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository.
For more information on setting up your environment and contributing, you may refer to the [ETSI Forge wiki](https://forge.etsi.org/wiki/index.php/Main_Page).
