*** Settings ***
Resource    NSLCMOperationKeywords.robot

*** Test Cases ***
POST VNF Snapshots - Method Not Implemented
    [Documentation]    Test ID: 5.3.2.27.1
    ...    Test title: POST VNF Snapshots - Method Not Implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST VNF Snapshots
    Check HTTP Response Status Code Is    405

GET information about multiple VNF Snapshots  
    [Documentation]    Test ID: 5.3.2.27.2
    ...    Test title: GET information about multiple VNF Snapshots
    ...    Test objective: The objective is to get information about multiples VNF snapshots
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 5.3.2.27.3
    ...    Test title: GET information about multiple VNF Snapshots Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about multiples VNF Snapshots with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshots Bad Request Invalid attribute selector
    [Documentation]    Test ID: 5.3.2.27.4
    ...    Test title: GET information about multiple VNF Snapshots Bad Request Invalid attribute selector
    ...    Test objective: The objective is to get information about multiples VNF Snapshots with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshots with "all_fields" attribute selector
    [Documentation]    Test ID: 5.3.2.27.5
    ...    Test title: GET information about multiple VNF Snapshots with "all_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo

GET information about multiple VNF Snapshots with "exclude_default" attribute selector
    [Documentation]    Test ID: 5.3.2.27.6
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_default" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots with "fields" attribute selector
    [Documentation]    Test ID: 5.3.2.27.7
    ...    Test title: GET information about multiple VNF Snapshots with "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo

GET information about multiple VNF Snapshots with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 5.3.2.27.8
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots with "exclude_fields" attribute selector
    [Documentation]    Test ID: 5.3.2.27.9
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo  
    
GET VNF Snapshots - Bad Request Response too Big
    [Documentation]    Test ID: 5.3.2.27.10
    ...    Test title: GET VNF Snapshots - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing VNF Snapshots list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support paged response.
    ...    Post-Conditions: none 
    GET VNF Snapshots without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET VNF Snapshots as Paged Response
    [Documentation]    Test ID: 5.3.2.27.11
    ...    Test title: GET VNF Snapshots as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing VNF Snapshots as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports paged response.
    ...    Post-Conditions: none    
    GET VNF Snapshots with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 5.3.2.27.12
    ...    Test title: PUT VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 6.4.19.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT VNF Snapshots
    Check HTTP Response Status Code Is    405

PATCH VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 5.3.2.27.13
    ...    Test title: PATCH VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 6.4.19.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNF Snapshots
    Check HTTP Response Status Code Is    405

DELETE VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 5.3.2.27.14
    ...    Test title: DELETE VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 6.4.19.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE VNF Snapshots
    Check HTTP Response Status Code Is    405
    
GET information about multiple VNF Snapshots using Filter
    [Documentation]    Test ID: 5.3.2.27.15
    ...    Test title: GET information about multiple VNF Snapshots using Filter
    ...    Test objective: The objective is to get information about multiples VNF snapshots using filter
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.19.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo