*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence

*** Test Cases ***
POST Revert to VNF Snapshot Task 
    [Documentation]    Test ID: 6.3.5.24.1
    ...    Test title: POST Revert to VNF Snapshot Task
    ...    Test objective: The objective is to test that POST method requests reverting a VNF/VNFC instance to a VNF/VNFC snapshot.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.1 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Revert to VNF Snapshot Task
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id

POST Revert to VNF Snapshot Task - NOT FOUND
    [Documentation]    Test ID: 6.3.5.24.2
    ...    Test title: POST Revert to VNF Snapshot Task - NOT FOUND
    ...    Test objective: The objective is to test that the POST method cannot request reverting to a snapshot if the task is not supported for the VNF instance represented by the parent resource. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.1 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: Task is not supported for the VNF instance represented by the parent resource.
    ...    Post-Conditions: none
    POST Revert to VNF Snapshot Task NOT SUPPORTED
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Revert to VNF Snapshot Task - CONFLICT
    [Documentation]    Test ID: 6.3.5.24.3
    ...    Test title: POST Revert to VNF Snapshot Task - CONFLICT
    ...    Test objective: The objective is to test that the POST method cannot request reverting to a snapshot when the VNF instance is in NOT_INSTANTIATED state. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.1 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: VNF instance is in NOT_INSTANTIATED state.
    ...    Post-Conditions: none
    POST Revert to VNF Snapshot Task VNF_NOT_INSTANTIATED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

GET Revert to VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.24.4
    ...    Test title: GET Revert to VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.2 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Revert to VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PUT Revert to VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.24.5
    ...    Test title: PUT Revert to VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.3 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT Revert to VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PATCH Revert to VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.24.6
    ...    Test title: PATCH Revert to VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.4 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH Revert to VNF Snapshot Task
    Check HTTP Response Status Code Is    405
    
DELETE Revert to VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.24.7
    ...    Test title: DELETE Revert to sVNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.22.3.5 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE Revert to VNF Snapshot Task
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200