/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.serialization.ObjectMapperFactory;

public class LogEntrySerializer {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public LogEntrySerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public String serialize(LogEntry logEntry) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(logEntry);
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing LogEntry to JSON with value %s", logEntry), e);
            throw new RuntimeException(String.format("Exception while serializing LogEntry to JSON with value %s", logEntry), e);
        }
    }

    public String serialize(List<LogEntry> logEntries) {
        return this.serialize(logEntries.toArray(new LogEntry[logEntries.size()]));
    }

    public String serialize(LogEntry ... logEntries) {
        try {
            if (logEntries != null && logEntries.length > 0) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(logEntries);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing LogEntry to JSON with value " + Arrays.asList(logEntries), e);
            throw new RuntimeException("Exception while serializing LogEntry to JSON with value " + Arrays.asList(logEntries), e);
        }
    }
}

