*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot    
Library           JSONLibrary
Library           OperatingSystem    
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

*** Test Cases ***
Get VNF Package Artifact
    [Documentation]    Test ID: 5.3.5.12.1
    ...    Test title: Get VNF Package Artifact
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get VNF Package Artifact with "exclude_all_mano_artifacts" parameter
    [Documentation]    Test ID: 5.3.5.12.2
    ...    Test title: Get VNF Package Artifact with "exclude_all_mano_artifacts" parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and it doesnot contain additional MANO artifacts  when requested with "exclude_all_mano_artifacts" parameter
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with exclude_all_mano_artifacts parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get VNF Package Artifact with "exclude_all_non_mano_artifacts" parameter
    [Documentation]    Test ID: 5.3.5.12.3
    ...    Test title: Get VNF Package Artifact with "exclude_all_non_mano_artifacts" parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and it doesnot contain non-MANO Artifacts when requested with "exclude_all_non_mano_artifacts" parameter
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with exclude_all_non_mano_artifacts parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get VNF Package Artifact with "select_non_mano_artifact_sets" parameter
    [Documentation]    Test ID: 5.3.5.12.4
    ...    Test title: Get VNF Package Artifact with "select_non_mano_artifact_sets" parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and also contain non_MANO artifacts set when requested with "select_non_mano_artifact_sets" parameter
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with select_non_mano_artifact_sets parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get VNF Package Artifact with "include_signatures" parameter
    [Documentation]    Test ID: 5.3.5.12.5
    ...    Test title: Get VNF Package Artifact with "include_signatures" parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and also contain security certificates when requested with "include_signature" parameter, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with include_signatures parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get VNF Package Artifact with Range Request and NFVO supporting Range Requests
    [Documentation]    Test ID: 5.3.5.12.6
    ...    Test title: Get VNF Package Artifact with Range Request and NFVO supporting Range Requests
    ...    Test objective: The objective is to test the GET request read the whole content of the archive containing the artifact files successfully when using a range request to return single range of bytes from the file, with the NFVO supporting it. The test also perform a validation that returned content matches the issued range
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO supports range requests to return single range of bytes from the VNF package artifact
    ...    Post-Conditions: none
    Get Artifact in VNF Package with Range Request
    Check HTTP Response Status Code Is    206
    Check HTTP Response Header Content-Range Is Present and Matches the requested range
    Check HTTP Response Header Content-Length Is Present and Matches the requested range length
    
Get VNF Package Artifact with invalid URI parameters "exclude_all_non_mano_artifacts", "select_non_mano_artifact_sets"
    [Documentation]    Test ID: 5.3.5.12.7
    ...    Test title: Get VNF Package Artifact with invalid URI parameters "exclude_all_non_mano_artifacts", "select_non_mano_artifact_sets"
    ...    Test objective: The objective is to test that the GET request to read the whole content of the archive containing the artifact files fails when both "exclude_all_non_mano_artifacts" and "select_non_mano_artifact_sets" are present in request
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with exclude_all_non_mano_artifacts and select_non_mano_artifact_sets
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
Get VNF Package Artifact with invalid URI parameters "exclude_all_non_mano_artifacts", "exclude_all_mano_artifacts"
    [Documentation]    Test ID: 5.3.5.12.8
    ...    Test title: Get VNF Package Artifact with invalid URI parameters "exclude_all_non_mano_artifacts", "exclude_all_mano_artifactss"
    ...    Test objective: The objective is to test that the GET request to read the whole content of the archive containing the artifact files fails when both "exclude_all_non_mano_artifacts" and "exclude_all_mano_artifacts" are present in request
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with exclude_all_non_mano_artifacts and exclude_all_mano_artifacts
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
Get VNF Package Artifact with invalid URI parameters undifend select_non_mano_artifact_sets
    [Documentation]    Test ID: 5.3.5.12.9
    ...    Test title: Get VNF Package Artifact with invalid URI parameters undefined select_non_mano_artifact_sets
    ...    Test objective: The objective is to test that the GET request to read the whole content of the archive containing the artifact files fails when one or more value provided in "select_non_mano_artifact_sets" are not provided in Manifest.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with select_non_mano_artifact_sets parameter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get VNF Package Artifact with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.5.12.10
    ...    Test title: Get VNF Package Artifact with conflict due to onboarding state
    ...    Test objective: The objective is to test that the GET request to read the whole content of the archive containing the artifact files fails due to a conflict when the VNF Package is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the VNF package for which the content is requested is different from ONBOARDED.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none   
    GET Artifact of VNF Package in onboarding state different from ONBOARDED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET VNF Package Artifact with invalid Range Request
    [Documentation]    Test ID: 5.3.5.12.11
    ...    Test title: GET VNF Package Artifact with invalid Range Request
    ...    Test objective: The objective is to test that the GET request to read the whole content of the archive containing the artifact files fails when using a range request that does not match any available byte range in the file.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO supports range requests to return single range of bytes from the VNF package artifact
    ...    Post-Conditions: none      
    GET VNF Package Artifact with invalid Range Request
    Check HTTP Response Status Code Is    416
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
POST VNF Package Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.12
    ...    Test title: POST VNF Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create new VNF Package artifact
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.5a.3.1 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for VNF Package Artifact
    Check HTTP Response Status Code Is    405

PUT VNF Package Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.13
    ...    Test title: PUT VNF Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify a VNF Package artifact
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.3 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for VNF Package Artifact
    Check HTTP Response Status Code Is    405

PATCH VNF Package Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.14
    ...    Test title: PATCH VNF Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that PATCH  method is not allowed to update a VNF Package artifact
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.4 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for VNF Package Artifact
    Check HTTP Response Status Code Is    405

DELETE VNF Package Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.15
    ...    Test title: DELETE VNF Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete a VNF Package artifact
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.6.3.5 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for VNF Package Artifact
    Check HTTP Response Status Code Is    405
    
Get VNF Package Artifact with "include_external_artifacts" parameter
    [Documentation]    Test ID: 5.3.5.12.16
    ...    Test title: Get VNF Package Artifact with "include_external_artifacts" parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and it contains external artifacts when requested with "include_external_artifacts" parameter
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.5a.3.2 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Artifact in VNF Package with include_external_artifacts parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip