/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.serialization.model.ConnectionOptionsDTO;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.DelayDTO;

public class HttpResponseDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpResponse> {
    private Integer statusCode;
    private String reasonPhrase;
    private BodyWithContentTypeDTO body;
    private Cookies cookies = new Cookies(new Cookie[0]);
    private Headers headers = new Headers(new Header[0]);
    private DelayDTO delay;
    private ConnectionOptionsDTO connectionOptions;

    public HttpResponseDTO() {
    }

    public HttpResponseDTO(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.statusCode = httpResponse.getStatusCode();
            this.reasonPhrase = httpResponse.getReasonPhrase();
            this.body = BodyWithContentTypeDTO.createDTO(httpResponse.getBody());
            this.headers = httpResponse.getHeaders();
            this.cookies = httpResponse.getCookies();
            this.delay = httpResponse.getDelay() != null ? new DelayDTO(httpResponse.getDelay()) : null;
            this.connectionOptions = httpResponse.getConnectionOptions() != null ? new ConnectionOptionsDTO(httpResponse.getConnectionOptions()) : null;
        }
    }

    @Override
    public HttpResponse buildObject() {
        return ((HttpResponse)new HttpResponse().withStatusCode(this.statusCode).withReasonPhrase(this.reasonPhrase).withBody(this.body != null ? this.body.buildObject() : null).withHeaders(this.headers).withCookies(this.cookies).withDelay(this.delay != null ? this.delay.buildObject() : null)).withConnectionOptions(this.connectionOptions != null ? this.connectionOptions.buildObject() : null);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponseDTO setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public HttpResponseDTO setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public BodyWithContentTypeDTO getBody() {
        return this.body;
    }

    public HttpResponseDTO setBody(BodyWithContentTypeDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpResponseDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpResponseDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpResponseDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }

    public ConnectionOptionsDTO getConnectionOptions() {
        return this.connectionOptions;
    }

    public HttpResponseDTO setConnectionOptions(ConnectionOptionsDTO connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }
}

