/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.mockserver.client.netty.proxy.ProxyConfiguration;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.dashboard.DashboardHandler;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.responsewriter.NettyResponseWriter;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.PortBindingSerializer;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf("PROXYING");
    public static final AttributeKey<Set> LOCAL_HOST_HEADERS = AttributeKey.valueOf("LOCAL_HOST_HEADERS");
    private MockServerLogger mockServerLogger;
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer;
    private LifeCycle server;
    private ActionHandler actionHandler;
    private DashboardHandler dashboardHandler = new DashboardHandler();

    public MockServerHandler(LifeCycle server, HttpStateHandler httpStateHandler, @Nullable ProxyConfiguration proxyConfiguration) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.portBindingSerializer = new PortBindingSerializer(this.mockServerLogger);
        this.actionHandler = new ActionHandler(httpStateHandler, proxyConfiguration);
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(PROXYING).get() != null) {
            return ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    public static Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(LOCAL_HOST_HEADERS) != null && ctx.channel().attr(LOCAL_HOST_HEADERS).get() != null) {
            return ctx.channel().attr(LOCAL_HOST_HEADERS).get();
        }
        return new HashSet<String>();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, final HttpRequest request) {
        block16: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                this.server.getScheduler().submit(new Runnable(){

                    @Override
                    public void run() {
                        String hostHeader = request.getFirstHeader(HttpHeaderNames.HOST.toString());
                        KeyAndCertificateFactory.addSubjectAlternativeName(hostHeader);
                    }
                });
                if (this.httpStateHandler.handle(request, responseWriter, false)) break block16;
                if (request.matches("PUT", "/mockserver/status", "/status")) {
                    ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getLocalPorts())), "application/json");
                    break block16;
                }
                if (request.matches("PUT", "/mockserver/bind", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindServerPorts(requestedPortBindings.getPorts());
                        ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block16;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create("text", "plain").toString());
                            break block16;
                        }
                        throw e;
                    }
                }
                if (request.getMethod().getValue().equals("GET") && request.getPath().getValue().startsWith("/mockserver/dashboard")) {
                    this.dashboardHandler.renderDashboard(ctx, request);
                } else if (request.matches("PUT", "/mockserver/stop", "/stop")) {
                    ctx.writeAndFlush(HttpResponse.response().withStatusCode(HttpResponseStatus.OK.code()));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MockServerHandler.this.server.stop();
                        }
                    }).start();
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    String username = ConfigurationProperties.httpProxyServerUsername();
                    String password = ConfigurationProperties.httpProxyServerPassword();
                    if (!(username.isEmpty() || password.isEmpty() || request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()) && request.getFirstHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()).toLowerCase(Locale.US).startsWith("basic ") && request.getFirstHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()).substring(6).equals(new Base64Converter().bytesToBase64String((username + ":" + password).getBytes(StandardCharsets.UTF_8))))) {
                        ctx.writeAndFlush(HttpResponse.response().withStatusCode(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code()).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), "Basic realm=\"" + ConfigurationProperties.httpProxyServerRealm().replace("\"", "\\\"") + "\""));
                    } else {
                        ctx.channel().attr(PROXYING).set(Boolean.TRUE);
                        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
                        this.server.getScheduler().submit(new Runnable(){

                            @Override
                            public void run() {
                                KeyAndCertificateFactory.addSubjectAlternativeName(request.getPath().getValue());
                            }
                        });
                        ctx.pipeline().addLast(new HttpConnectHandler(this.server, this.mockServerLogger, request.getPath().getValue(), -1));
                        ctx.pipeline().remove(this);
                        ctx.fireChannelRead(request);
                    }
                } else {
                    this.actionHandler.processAction(request, responseWriter, ctx, MockServerHandler.getLocalAddresses(ctx), MockServerHandler.isProxyingRequest(ctx), false);
                }
            }
            catch (IllegalArgumentException iae) {
                this.mockServerLogger.error(request, "exception processing: {} error: {}", request, iae.getMessage());
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create("text", "plain").toString());
            }
            catch (Exception e) {
                this.mockServerLogger.error(request, (Throwable)e, "exception processing " + request, new Object[0]);
                ((ResponseWriter)responseWriter).writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.BAD_REQUEST.code()).withBody(e.getMessage()), true);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            new MockServerLogger(this.getClass()).error("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

