/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mockserver.character.Character;
import org.mockserver.configuration.IntegerStringListParser;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.KeyStoreFactory;
import org.slf4j.event.Level;

public class ConfigurationProperties {
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final long DEFAULT_MAX_TIMEOUT = 20L;
    private static final int DEFAULT_CONNECT_TIMEOUT = 20000;
    private static final int DEFAULT_MAX_EXPECTATIONS = 1000;
    private static final int DEFAULT_NIO_EVENT_LOOP_THREAD_COUNT = Math.max(1, SystemPropertyUtil.getInt("io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 5));
    private static final Properties PROPERTIES = ConfigurationProperties.readPropertyFile();
    private static final Set<String> ALL_SUBJECT_ALTERNATIVE_DOMAINS = Sets.newConcurrentHashSet();
    private static final Set<String> ALL_SUBJECT_ALTERNATIVE_IPS = Sets.newConcurrentHashSet();
    private static final AtomicBoolean REBUILD_KEY_STORE = new AtomicBoolean(false);
    private static final IntegerStringListParser INTEGER_STRING_LIST_PARSER = new IntegerStringListParser();

    private static String propertyFile() {
        return System.getProperty("mockserver.propertyFile", "mockserver.properties");
    }

    public static boolean enableCORSForAPI() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.enableCORSForAPI", "true"));
    }

    public static boolean enableCORSForAPIHasBeenSetExplicitly() {
        return System.getProperty("mockserver.enableCORSForAPI") != null || PROPERTIES.getProperty("mockserver.enableCORSForAPI") != null;
    }

    public static void enableCORSForAPI(boolean enableCORSForAPI) {
        System.setProperty("mockserver.enableCORSForAPI", "" + enableCORSForAPI);
    }

    public static boolean enableCORSForAllResponses() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.enableCORSForAllResponses", "false"));
    }

    public static void enableCORSForAllResponses(boolean enableCORSForAPI) {
        System.setProperty("mockserver.enableCORSForAllResponses", "" + enableCORSForAPI);
    }

    public static int maxExpectations() {
        return ConfigurationProperties.readIntegerProperty("mockserver.maxExpectations", 1000);
    }

    public static void maxExpectations(int count) {
        System.setProperty("mockserver.maxExpectations", "" + count);
    }

    public static int nioEventLoopThreadCount() {
        return ConfigurationProperties.readIntegerProperty("mockserver.nioEventLoopThreadCount", DEFAULT_NIO_EVENT_LOOP_THREAD_COUNT);
    }

    public static void nioEventLoopThreadCount(int count) {
        System.setProperty("mockserver.nioEventLoopThreadCount", "" + count);
    }

    public static long maxSocketTimeout() {
        return ConfigurationProperties.readLongProperty("mockserver.maxSocketTimeout", TimeUnit.SECONDS.toMillis(20L));
    }

    public static void maxSocketTimeout(long milliseconds) {
        System.setProperty("mockserver.maxSocketTimeout", "" + milliseconds);
    }

    public static int socketConnectionTimeout() {
        return ConfigurationProperties.readIntegerProperty("mockserver.socketConnectionTimeout", 20000);
    }

    public static void socketConnectionTimeout(int milliseconds) {
        System.setProperty("mockserver.socketConnectionTimeout", "" + milliseconds);
    }

    public static String javaKeyStoreFilePath() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreFilePath", KeyStoreFactory.defaultKeyStoreFileName());
    }

    public static void javaKeyStoreFilePath(String keyStoreFilePath) {
        System.setProperty("mockserver.javaKeyStoreFilePath", keyStoreFilePath);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStorePassword() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStorePassword", "changeit");
    }

    public static void javaKeyStorePassword(String keyStorePassword) {
        System.setProperty("mockserver.javaKeyStorePassword", keyStorePassword);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStoreType() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreType", KeyStore.getDefaultType());
    }

    public static void javaKeyStoreType(String keyStoreType) {
        System.setProperty("mockserver.javaKeyStoreType", keyStoreType);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static boolean deleteGeneratedKeyStoreOnExit() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.deleteGeneratedKeyStoreOnExit", "true"));
    }

    public static void deleteGeneratedKeyStoreOnExit(boolean deleteGeneratedKeyStoreOnExit) {
        System.setProperty("mockserver.deleteGeneratedKeyStoreOnExit", "" + deleteGeneratedKeyStoreOnExit);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String sslCertificateDomainName() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.sslCertificateDomainName", "localhost");
    }

    public static void sslCertificateDomainName(String domainName) {
        System.setProperty("mockserver.sslCertificateDomainName", domainName);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String[] sslSubjectAlternativeNameDomains() {
        return ALL_SUBJECT_ALTERNATIVE_DOMAINS.toArray(new String[ALL_SUBJECT_ALTERNATIVE_DOMAINS.size()]);
    }

    public static void addSslSubjectAlternativeNameDomains(String ... newSubjectAlternativeNameDomains) {
        boolean subjectAlternativeDomainsModified = false;
        for (String subjectAlternativeDomain : newSubjectAlternativeNameDomains) {
            if (!ALL_SUBJECT_ALTERNATIVE_DOMAINS.add(subjectAlternativeDomain.trim())) continue;
            subjectAlternativeDomainsModified = true;
        }
        if (subjectAlternativeDomainsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameDomains", Joiner.on(",").join(new TreeSet<String>(ALL_SUBJECT_ALTERNATIVE_DOMAINS)));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static void clearSslSubjectAlternativeNameDomains() {
        ALL_SUBJECT_ALTERNATIVE_DOMAINS.clear();
    }

    public static boolean containsSslSubjectAlternativeName(String domainOrIp) {
        return ALL_SUBJECT_ALTERNATIVE_DOMAINS.contains(domainOrIp) || ALL_SUBJECT_ALTERNATIVE_IPS.contains(domainOrIp);
    }

    public static String[] sslSubjectAlternativeNameIps() {
        return ALL_SUBJECT_ALTERNATIVE_IPS.toArray(new String[ALL_SUBJECT_ALTERNATIVE_IPS.size()]);
    }

    public static void addSslSubjectAlternativeNameIps(String ... newSubjectAlternativeNameIps) {
        boolean subjectAlternativeIpsModified = false;
        for (String subjectAlternativeIp : newSubjectAlternativeNameIps) {
            if (!ALL_SUBJECT_ALTERNATIVE_IPS.add(subjectAlternativeIp.trim())) continue;
            subjectAlternativeIpsModified = true;
        }
        if (subjectAlternativeIpsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameIps", Joiner.on(",").join(new TreeSet<String>(ALL_SUBJECT_ALTERNATIVE_IPS)));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static void clearSslSubjectAlternativeNameIps() {
        ALL_SUBJECT_ALTERNATIVE_IPS.clear();
        ConfigurationProperties.addSslSubjectAlternativeNameIps(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameIps", "127.0.0.1,0.0.0.0").split(","));
    }

    public static boolean rebuildKeyStore() {
        return REBUILD_KEY_STORE.get();
    }

    public static void rebuildKeyStore(boolean rebuildKeyStore) {
        REBUILD_KEY_STORE.set(rebuildKeyStore);
    }

    public static List<Integer> mockServerPort() {
        return ConfigurationProperties.readIntegerListProperty("mockserver.mockServerPort", -1);
    }

    public static void mockServerPort(Integer ... port) {
        System.setProperty("mockserver.mockServerPort", INTEGER_STRING_LIST_PARSER.toString(port));
    }

    public static Level logLevel() {
        return Level.valueOf(System.getProperty("mockserver.logLevel", DEFAULT_LOG_LEVEL));
    }

    public static void logLevel(String level) {
        if (!Arrays.asList("TRACE", "DEBUG", DEFAULT_LOG_LEVEL, "WARN", "ERROR", "OFF").contains(level)) {
            throw new IllegalArgumentException("log level \"" + level + "\" is not legal it must be one of \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\"");
        }
        System.setProperty("mockserver.logLevel", level);
    }

    public static boolean disableRequestAudit() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.disableRequestAudit", "false"));
    }

    public static void disableRequestAudit(boolean disableRequestAudit) {
        System.setProperty("mockserver.disableRequestAudit", "" + disableRequestAudit);
    }

    public static boolean disableSystemOut() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.disableSystemOut", "false"));
    }

    public static void disableSystemOut(boolean disableSystemOut) {
        System.setProperty("mockserver.disableSystemOut", "" + disableSystemOut);
    }

    public static InetSocketAddress httpProxy() {
        return ConfigurationProperties.readInetSocketAddressProperty("mockserver.httpProxy");
    }

    public static InetSocketAddress httpsProxy() {
        return ConfigurationProperties.readInetSocketAddressProperty("mockserver.httpsProxy");
    }

    public static InetSocketAddress socksProxy() {
        return ConfigurationProperties.readInetSocketAddressProperty("mockserver.socksProxy");
    }

    public static String httpProxyServerRealm() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.httpProxyServerRealm", "MockServer HTTP Proxy");
    }

    public static void httpProxyServerRealm(String httpProxyServerRealm) {
        System.setProperty("mockserver.httpProxyServerRealm", httpProxyServerRealm);
    }

    public static String httpProxyServerUsername() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.httpProxyServerUsername", "");
    }

    public static void httpProxyServerUsername(String httpProxyServerUsername) {
        System.setProperty("mockserver.httpProxyServerUsername", httpProxyServerUsername);
    }

    public static String httpProxyServerPassword() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.httpProxyServerPassword", "");
    }

    public static void httpProxyServerPassword(String httpProxyServerPassword) {
        System.setProperty("mockserver.httpProxyServerPassword", httpProxyServerPassword);
    }

    public static String socksProxyServerUsername() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.socksProxyServerUsername", "");
    }

    public static void socksProxyServerUsername(String socksProxyServerUsername) {
        System.setProperty("mockserver.socksProxyServerUsername", socksProxyServerUsername);
    }

    public static String socksProxyServerPassword() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.socksProxyServerPassword", "");
    }

    public static void socksProxyServerPassword(String socksProxyServerPassword) {
        System.setProperty("mockserver.socksProxyServerPassword", socksProxyServerPassword);
    }

    private static InetSocketAddress readInetSocketAddressProperty(String s) {
        String[] proxyParts;
        InetSocketAddress inetSocketAddress = null;
        String proxy = ConfigurationProperties.readPropertyHierarchically(s, null);
        if (!Strings.isNullOrEmpty(proxy) && (proxyParts = proxy.split(":")).length > 1) {
            try {
                inetSocketAddress = new InetSocketAddress(proxyParts[0], Integer.parseInt(proxyParts[1]));
            }
            catch (NumberFormatException nfe) {
                MockServerLogger.MOCK_SERVER_LOGGER.error("NumberFormatException converting value \"" + proxyParts[1] + "\" into an integer", nfe);
            }
        }
        return inetSocketAddress;
    }

    private static List<Integer> readIntegerListProperty(String key, Integer defaultValue) {
        try {
            return INTEGER_STRING_LIST_PARSER.toList(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            MockServerLogger.MOCK_SERVER_LOGGER.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", nfe);
            return Collections.emptyList();
        }
    }

    private static Integer readIntegerProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            MockServerLogger.MOCK_SERVER_LOGGER.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", nfe);
            return defaultValue;
        }
    }

    private static Long readLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            MockServerLogger.MOCK_SERVER_LOGGER.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", nfe);
            return defaultValue;
        }
    }

    private static Properties readPropertyFile() {
        Properties properties;
        block27: {
            properties = new Properties();
            try (InputStream inputStream2 = ConfigurationProperties.class.getClassLoader().getResourceAsStream(ConfigurationProperties.propertyFile());){
                if (inputStream2 != null) {
                    try {
                        properties.load(inputStream2);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (MockServerLogger.MOCK_SERVER_LOGGER != null) {
                            MockServerLogger.MOCK_SERVER_LOGGER.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", e);
                        }
                        break block27;
                    }
                }
                if (MockServerLogger.MOCK_SERVER_LOGGER != null) {
                    MockServerLogger.MOCK_SERVER_LOGGER.debug(MessageLogEntry.LogMessageType.SERVER_CONFIGURATION, "Property file not found on classpath using path [" + ConfigurationProperties.propertyFile() + "]", new Object[0]);
                }
                try {
                    properties.load(new FileInputStream(ConfigurationProperties.propertyFile()));
                }
                catch (FileNotFoundException e) {
                    if (MockServerLogger.MOCK_SERVER_LOGGER != null) {
                        MockServerLogger.MOCK_SERVER_LOGGER.debug(MessageLogEntry.LogMessageType.SERVER_CONFIGURATION, "Property file not found using path [" + ConfigurationProperties.propertyFile() + "]", new Object[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (MockServerLogger.MOCK_SERVER_LOGGER != null) {
                        MockServerLogger.MOCK_SERVER_LOGGER.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", e);
                    }
                }
            }
            catch (IOException inputStream2) {
                // empty catch block
            }
        }
        if (!properties.isEmpty()) {
            Enumeration<?> propertyNames = properties.propertyNames();
            StringBuilder propertiesLogDump = new StringBuilder();
            propertiesLogDump.append("Reading properties from property file [").append(ConfigurationProperties.propertyFile()).append("]:" + Character.NEW_LINE);
            while (propertyNames.hasMoreElements()) {
                String propertyName = String.valueOf(propertyNames.nextElement());
                propertiesLogDump.append("\t").append(propertyName).append(" = ").append(properties.getProperty(propertyName)).append(Character.NEW_LINE);
            }
            if (MockServerLogger.MOCK_SERVER_LOGGER != null) {
                MockServerLogger.MOCK_SERVER_LOGGER.info(MessageLogEntry.LogMessageType.SERVER_CONFIGURATION, propertiesLogDump.toString(), new Object[0]);
            }
        }
        return properties;
    }

    private static String readPropertyHierarchically(String key, String defaultValue) {
        return System.getProperty(key, PROPERTIES != null ? PROPERTIES.getProperty(key, defaultValue) : defaultValue);
    }

    static {
        ConfigurationProperties.addSslSubjectAlternativeNameDomains(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameDomains", "localhost").split(","));
        ConfigurationProperties.addSslSubjectAlternativeNameIps(ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameIps", "127.0.0.1,0.0.0.0").split(","));
    }
}

