/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.callback;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.mockserver.callback.WebSocketRequestCallback;
import org.mockserver.callback.WebSocketResponseCallback;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;

public class WebSocketClientRegistry {
    public static final String WEB_SOCKET_CORRELATION_ID_HEADER_NAME = "WebSocketCorrelationId";
    private WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer(new MockServerLogger());
    private CircularHashMap<String, ChannelHandlerContext> clientRegistry = new CircularHashMap(1000);
    private CircularHashMap<String, WebSocketResponseCallback> callbackResponseRegistry = new CircularHashMap(1000);
    private CircularHashMap<String, WebSocketRequestCallback> callbackForwardRegistry = new CircularHashMap(1000);

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block6: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (deserializedMessage instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)deserializedMessage;
                    String firstHeader = httpResponse.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketResponseCallback webSocketResponseCallback = (WebSocketResponseCallback)this.callbackResponseRegistry.get(firstHeader);
                    if (webSocketResponseCallback != null) {
                        webSocketResponseCallback.handle(httpResponse);
                    }
                    break block6;
                }
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                    WebSocketRequestCallback webSocketRequestCallback = (WebSocketRequestCallback)this.callbackForwardRegistry.get(httpRequest.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME));
                    if (webSocketRequestCallback != null) {
                        webSocketRequestCallback.handle(httpRequest);
                    }
                    break block6;
                }
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message" + textWebSocketFrame.text(), e);
            }
        }
    }

    void registerClient(String clientId, ChannelHandlerContext ctx) {
        try {
            ctx.channel().writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketClientIdDTO().setClientId(clientId))));
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket registration client id message to client " + clientId, e);
        }
        this.clientRegistry.put(clientId, ctx);
    }

    public void registerCallbackHandler(String webSocketCorrelationId, WebSocketResponseCallback expectationResponseCallback) {
        this.callbackResponseRegistry.put(webSocketCorrelationId, expectationResponseCallback);
    }

    public void registerCallbackHandler(String webSocketCorrelationId, WebSocketRequestCallback expectationForwardCallback) {
        this.callbackForwardRegistry.put(webSocketCorrelationId, expectationForwardCallback);
    }

    public void sendClientMessage(String clientId, HttpRequest httpRequest) {
        try {
            if (this.clientRegistry.containsKey(clientId)) {
                ((ChannelHandlerContext)this.clientRegistry.get(clientId)).channel().writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequest)));
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket message " + httpRequest + " to client " + clientId, e);
        }
    }
}

