/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.script.VelocityCompiledScript;
import org.apache.velocity.script.VelocityScriptEngineFactory;

public class VelocityScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String VELOCITY_PROPERTIES_KEY = "org.apache.velocity.script.properties";
    private volatile ScriptEngineFactory factory;
    private volatile RuntimeInstance velocityEngine;

    public VelocityScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    public VelocityScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    protected RuntimeInstance getVelocityEngine() {
        return this.velocityEngine;
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.initVelocityEngine(scriptContext);
        String string = VelocityScriptEngine.getFilename(scriptContext);
        VelocityContext velocityContext = VelocityScriptEngine.getVelocityContext(scriptContext);
        Writer writer = scriptContext.getWriter();
        if (writer == null) {
            writer = new StringWriter();
            scriptContext.setWriter(writer);
        }
        try {
            this.velocityEngine.evaluate((Context)velocityContext, writer, string, reader);
            writer.flush();
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.factory == null) {
                    this.factory = new VelocityScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVelocityEngine(ScriptContext scriptContext) {
        if (scriptContext == null) {
            scriptContext = this.getContext();
        }
        if (this.velocityEngine == null) {
            VelocityScriptEngine velocityScriptEngine = this;
            synchronized (velocityScriptEngine) {
                if (this.velocityEngine != null) {
                    return;
                }
                Properties properties = VelocityScriptEngine.getVelocityProperties(scriptContext);
                RuntimeInstance runtimeInstance = new RuntimeInstance();
                try {
                    if (properties != null) {
                        runtimeInstance.init(properties);
                    } else {
                        runtimeInstance.init();
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                this.velocityEngine = runtimeInstance;
            }
        }
    }

    protected static VelocityContext getVelocityContext(ScriptContext scriptContext) {
        scriptContext.setAttribute("context", scriptContext, 100);
        Bindings bindings = scriptContext.getBindings(200);
        Bindings bindings2 = scriptContext.getBindings(100);
        if (bindings != null) {
            return new VelocityContext(bindings2, new VelocityContext(bindings));
        }
        return new VelocityContext(bindings2);
    }

    protected static String getFilename(ScriptContext scriptContext) {
        Object object = scriptContext.getAttribute("javax.script.filename");
        return object != null ? object.toString() : "<unknown>";
    }

    protected static Properties getVelocityProperties(ScriptContext scriptContext) {
        try {
            File file;
            Object object = scriptContext.getAttribute(VELOCITY_PROPERTIES_KEY);
            if (object instanceof Properties) {
                return (Properties)object;
            }
            String string = System.getProperty(VELOCITY_PROPERTIES_KEY);
            if (string != null && (file = new File(string)).exists() && file.canRead()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                return properties;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return null;
    }

    @Override
    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        this.initVelocityEngine(null);
        SingleResourceReader singleResourceReader = new SingleResourceReader(reader);
        Template template = new Template();
        template.setRuntimeServices(this.velocityEngine);
        template.setResourceLoader(singleResourceReader);
        try {
            template.process();
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        return new VelocityCompiledScript(this, template);
    }

    protected static class SingleResourceReader
    extends StringResourceLoader {
        private Reader reader;

        public SingleResourceReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
            return this.reader;
        }
    }
}

