*** Settings ***
Library    String
Resource    environment/variables.txt
Library    REST     ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
#Suite Teardown    Terminate All Processes    kill=true
Library    MockServerLibrary
Library    Process

*** Keywords ***
Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port} 
    
Check Individual Subscription existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    Log    Validate Status code    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check HTTP Response Header Contains
    [Arguments]    ${HEADER_TOCHECK}
    Should Contain     ${response['headers']}    ${HEADER_TOCHECK}
    Log    Header is present    
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check HTTP Response Header ContentType is 
    [Arguments]    ${expected_contentType}
    Log    Validate content type
    Should Be Equal    ${response['headers']['Content-Type']}    ${expected_contentType}
    Log    Content Type validated 
      
Check Postcondition VNF Virtualised Resources Quota Available Notification individual Subscriptions is Deleted
    Log    Check Postcondition Subscription is deleted
    Get Virtualised Resources Quota Available Notification individual subscription
    Check HTTP Response Status Code Is    404 
    
Send Post request for Virtualised Resources Quota Available Notification Individual Subscription
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Put Virtualised Resources Quota Available Notification individual Subscription
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Patch Virtualised Resources Quota Available Notification individual subscription
    log    Trying to perform a Patch. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Get Virtualised Resources Quota Available Notification individual subscription 
    log    Trying to get information about an individual subscription
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
      
Delete Virtualised Resources Quota Available Notification individual subscription
    log    Try to delete an individual subscription
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}   
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Send Post request for new Virtualised Resources Quota Available Notification subscription 
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/vrQuotaAvailSubscriptionRequest.json
    ${body}=        Format String   ${template}    callback_uri=${callback_uri}:${callback_port}    callback_subscribe=${callback_subscribe}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Log    Verify that the notification endpoint has been tested
	Verify Mock Expectation    ${notification_request}
	Clear Requests    ${callback_endpoint}
    
Send Post request for new Virtualised Resources Quota Available Notification subscription - DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 0    NVFO is not permitting duplication. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/vrQuotaAvailSubscriptionRequest.json
    ${body}=        Format String   ${template}    callback_uri=${callback_uri}:${callback_port}    callback_subscribe=${callback_subscribe}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Log    Verify that the notification endpoint has been tested
	Verify Mock Expectation    ${notification_request}
	Clear Requests    ${callback_endpoint}
    
Send Post request for new Virtualised Resources Quota Available Notification subscription - NO-DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 1    VNFM permits duplication. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/vrQuotaAvailSubscriptionRequest.json
    ${body}=        Format String   ${template}    callback_uri=${callback_uri}:${callback_port}    callback_subscribe=${callback_subscribe}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Log    Verify that the notification endpoint has been tested
	Verify Mock Expectation    ${notification_request}
	Clear Requests    ${callback_endpoint}
    
GET Virtualised Resources Quota Available Notification Subscriptions
    Log    Get the list of active subscriptions
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}

GET Virtualised Resources Quota Available Notification Subscriptions with nextpage_opaque_marker parameter
    Log    Get next page of subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query using the URI provided in the previous GET request and validate response
    Get    ${nextPageUri}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
     
GET Virtualised Resources Quota Available Notification Subscriptions with Filter
    Log    Get the list of active subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Get Virtualised Resources Quota Available Notification subscriptions with Bad Request Invalid attribute-based filtering parameters    
     Log    Get the list of active subscriptions using an invalid filter
    Set Headers    {"Accept": "${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter_invalid}
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}
    
Send Put request for Virtualised Resources Quota Available Notification subscription 
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse} 
    
Send Patch request for Virtualised Resources Quota Available Notification subscription
    log    Trying to perform a Patch. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}  
    
Send Delete request for Virtualised Resources Quota Available Notification subscription
    log    Trying to perform a Delete. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${outputResponse}=    Output    response 
    Set Global Variable    ${response}    ${outputResponse}     
    
Check HTTP Response Header Contain Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}
    Log    Check that Link header contains rel set to next
    Should Contain    ${linkURL}    rel="next"
    Log    Check that Link header contains URI to next page between <>
    ${linkHeaderUri}=    Get Regexp Matches    ${linkURL}    (?<=\<)(.*?)(?=\>)
    ${length}=    Get Length    ${linkHeaderUri}	
    Should Be Equal As Integers	${length}	0
    Set Global Variable    ${nextPageUri}    ${linkHeaderUri[0]}   
      