# NFV SOL005 APIs

This repository hosts the [OpenAPI](https://www.openapis.org/) specificatons and other documentation
for the APIs defined in ETSI NFV GSs [SOL005](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/005/02.06.01_60/gs_NFV-SOL005v020601p.pdf).

The APIs described in this repository are defined for the `Os-Ma-nfvo` reference point.

**IMPORTANT: Please note that this file might be not aligned to the current version of the ETSI Group Specification it refers to and has not been approved by the ETSI NFV ISG. In case of discrepancies the published ETSI Group Specification takes precedence.**

More information at [NFV Solutions wiki](https://nfvwiki.etsi.org/index.php?title=NFV_Solutions).

## Content structure

All the main OpenAPI files should be put in the `src` directory and organized with the following schema:

    src/deliverable-number/api-name/api-name.yaml
   
e.g.

    src/SOL005/NSDManagement/NSDManagement.yaml
   
   
## Building

The build file `.jenkins.sh` will validate the files, evaluate JSON references and store the generated files in the build directory. In case the build is executed by Jenkins, the merged file will be store in a specific directory to be web-served.

To build locally, once Docker is installed, simple run

    $ sudo bash .jenkins.sh
   
and the results will be stored in a `build/` directory in the project folder.

## How to raise issues

Change requests can be filed at [ETSI Forge Bugzilla](forge.etsi.org/bugzilla/buglist.cgi?component=Nfv-Openapis&list_id=62&product=NFV). Please report errors, bugs or other issues [here](https://forge.etsi.org/bugzilla/enter_bug.cgi?product=NFV).

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository. Check the project page [here](https://forge.etsi.org/gitlab/nfv/SOL005).
For more information on setting up your environment and contributing, you may refer to the [ETSI Forge wiki](https://forge.etsi.org/wiki/index.php/Main_Page).

### Latest builds

See the recent builds from:

* [Master branch](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol005-master/)
* [Other branches](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol005/).

## License

Copyright (c) ETSI 2019.
 
This software is subject to copyrights owned by ETSI. Non-exclusive permission 
is hereby granted, free of charge, to copy, reproduce and amend this file 
under the following conditions: It is provided "as is", without warranty of any 
kind, expressed or implied. 

ETSI shall never be liable for any claim, damages, or other liability arising 
from its use or inability of use.This permission does not apply to any documentation 
associated with this file for which ETSI keeps all rights reserved. The present 
copyright notice shall be included in all copies of whole or part of this 
file and shall not imply any sub-license right.

