# NFV SOL002 and SOL003 APIs

This repository hosts the [OpenAPI](https://www.openapis.org/) specificatons and other documentation
for the APIs defined in ETSI NFV GSs [SOL002](http://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/02.03.01_60/gs_NFV-SOL002v020301p.pdf) and [SOL003](http://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/02.03.01_60/gs_NFV-SOL003v020301p.pdf).

The APIs described in this repository are defined for the following reference points:

* `Or-Vnfm`
* `Ve-vnfm`

**IMPORTANT: Please note that this file might be not aligned to the current version of the ETSI Group Specification it refers to and has not been approved by the ETSI NFV ISG. In case of discrepancies the published ETSI Group Specification takes precedence.**

More information at [NFV Solutions wiki](https://nfvwiki.etsi.org/index.php?title=NFV_Solutions).

## Content structure

All the main OpenAPI files should be put in the `src` directory and organized with the following schema:

    src/deliverable-number/api-name/api-name.yaml
   
e.g.

    src/SOL003/LifeCycleManagement/lifeCycleManagement.yaml
   
   
## Building

The build file `.jenkins.sh` will validate the files, evaluate JSON references and store the generated files in the build directory. In case the build is executed by Jenkins, the merged file will be store in a specific directory to be web-served.

To build locally, once Docker is installed, simple run

    $ sudo bash .jenkins.sh
   
and the results will be stored in a `build/` directory in the project folder.

## How to raise issues

Change requests can be filed at [ETSI Forge Bugzilla](forge.etsi.org/bugzilla/buglist.cgi?component=Nfv-Openapis&list_id=62&product=NFV). Please report errors, bugs or other issues [here](https://forge.etsi.org/bugzilla/enter_bug.cgi?product=NFV).

## How to contribute

ETSI Forge uses Gerrit to manage submissions to the repository, any submission is tracked with a Change. Currently open and closed Changes can be reviewed [here](https://forge.etsi.org/gerrit/#/q/project:NFV-SOL002-SOL003).

### Latest builds

See the recent builds from:

* [Master](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol002-sol003-master/)
* [Gerrit changes](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol002-sol003/).


