/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriAckMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriStatusRead;
import org.elvior.ttcn.tritci.XTriStatusRead;
import org.etsi.ttcn.tri.TriCommunicationSA;
import org.etsi.ttcn.tri.TriStatus;

class TriSnapshotMessage
extends AbstractTriTciMessage {
    private TriComponentIdImpl m_compId;

    public TriSnapshotMessage(TriComponentIdImpl compId) {
        this.m_compId = compId;
    }

    public TriSnapshotMessage() {
        this.m_compId = new TriComponentIdImpl();
    }

    public TriComponentIdImpl getComponentId() {
        return this.m_compId;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.Snapshot;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_compId.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_compId.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriSnapshotMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status;
        AbstractTriAckMessage ack = null;
        TriCommunicationSA sa = TriProvider.getInstance().getTriCommunicationSA();
        try {
            status = sa instanceof TriStatusRead ? ((TriStatusRead)((Object)sa)).triSnapshot(this.m_compId) : (sa instanceof XTriStatusRead ? ((XTriStatusRead)((Object)sa)).triSnapshot(this.m_compId) : TriStatusImpl.ok());
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        return new AdapterProcessingResult(status, ack);
    }
}

