/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriPortMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriPortId;
import org.etsi.ttcn.tri.TriStatus;

class TriNextSamplingMessage
extends AbstractTriPortMessage {
    private long m_nTick;

    public TriNextSamplingMessage() {
    }

    public TriNextSamplingMessage(TriPortId port, long nTick) {
        super(port);
        this.m_nTick = nTick;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriNextSamplingMessage();
    }

    public long getTick() {
        return this.m_nTick;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriPlatformPA().triNextSampling(this.m_nTick, this.getPort());
        return new AdapterProcessingResult(status);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TriNextSamplingMessage.writeLong(ms, this.m_nTick);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_nTick = TriNextSamplingMessage.readLong(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.NextSampling;
    }
}

