/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.ttcn.part9.xmldiff;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.custommonkey.xmlunit.Difference;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiff;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DiffErrorHandler
implements ErrorHandler {
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private static final String NEWLINE = System.getProperty("line.separator");
    private boolean hasErrors = false;
    private StringBuilder description = new StringBuilder();

    public String getErrorsText() {
        return this.description.toString();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public synchronized void reset(boolean clearLog) {
        this.hasErrors = false;
        if (clearLog) {
            this.description = new StringBuilder();
        }
    }

    @Override
    public void error(SAXParseException err) throws SAXException {
        this.errors.add(err);
        this.appendDescripion(err);
        this.hasErrors = true;
        XmlDiff.logger.warning("Fatal error while parsing: ", err.getMessage());
    }

    @Override
    public void fatalError(SAXParseException err) throws SAXException {
        this.errors.add(err);
        this.appendDescripion(err);
        this.hasErrors = true;
        XmlDiff.logger.warning("Error while parsing: ", err.getMessage());
    }

    private synchronized void appendDescripion(Throwable err) {
        StringWriter sw = new StringWriter();
        err.printStackTrace(new PrintWriter(sw));
        this.description.append(sw).append(NEWLINE);
    }

    @Override
    public void warning(SAXParseException warn) throws SAXException {
        this.warnings.add(warn);
        XmlDiff.logger.warning("Error while parsing: ", warn.getMessage());
    }

    public void difference(Difference diff) {
        this.hasErrors = true;
        this.appendDescripion(diff);
    }

    private synchronized void appendDescripion(Difference diff) {
        this.description.append(diff.getDescription()).append(NEWLINE);
    }
}

