package org.etsi.mts.ttcn.part9.xmldiff.regression;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

import org.etsi.mts.ttcn.part9.xmldiff.XmlDiff;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiffError;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class RegressionTest_001 {
	public static final String FOLDER = "regression/001_float_chinese_typename";
	public static String XSD_FILE = "Pos_050202_name_conversion_rules_014.xsd";
	public static String FILE_1= "Pos_050202_name_conversion_rules_014.xml";
	public static String FILE_2 = "sample.xml";
	public static final String FILE_base = FILE_1;
	
	private File root;
	private XmlDiff differ;
	private StringBuilder errors;
	private Reader actual;
	
	@Before
	public void setUp() throws IOException {
		root = new File(FOLDER);
		differ = new XmlDiff(
				new File(root, FILE_base), 
				new String[]{XSD_FILE},
				new String[]{FOLDER});
		errors = new StringBuilder();
	}
	
	@Test
	public void test_self() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_base));
		
		boolean v = differ.diff(actual, errors);
		assertEquals("", errors.toString());
		assertTrue(v);
	}
	
	@Test
	public void test_2() throws IOException, XmlDiffError {
		actual = new FileReader(new File(root, FILE_2));
		
		boolean v = differ.diff(actual, errors);
		
		assertEquals("", errors.toString());
		assertTrue(v);
	}

}
