package org.etsi.mts.ttcn.part9.xmldiff;

import static org.junit.Assert.*;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.junit.Test;

public class Test_001 {
	public static final String PREFIX = "xml/001";
	public static final String REFERENCE_XML = PREFIX + "/books.xml";
	
	@Test
	public void pos_001_nowhitespaces() throws IOException, XmlDiffError {
		XmlDiff differ = new XmlDiff(REFERENCE_XML, null, null);
		String textXml = "books_nowhitespaces.xml";
		String text = new String(Files.readAllBytes(Paths.get(PREFIX, textXml)), 
				StandardCharsets.UTF_8);
		StringBuilder error = new StringBuilder();
		
		boolean v = differ.diff(text, error);
		
		assertEquals("", error.toString());
		assertTrue("The XML files must be considered similar", v);
	}

}
