package org.etsi.mts.ttcn.part9.xmldiff;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/** Internal type for debugging purposes.
 * 
 * Do not use.  
 */
class DomTraversal {
	public void processNode(Node node, String prefix) {
		System.out.println(prefix + "#" + node.hashCode());
		if (node.getNodeType() == Node.DOCUMENT_NODE) {
			System.out.println(prefix + "Document: " + node.getNodeName());
		} else if (node.getNodeType() == Node.ELEMENT_NODE) {
			System.out.println(prefix + "Element: " + node.getNodeName());
			Element element = (Element) node;
			System.out.println(prefix + "--" + element.getSchemaTypeInfo().getTypeName());
		} else if (node.getNodeType() == Node.TEXT_NODE) {
			System.out.println(prefix + "Text: {" + node.getTextContent() + "}");
		} else {
			System.out.println(prefix + "smt else: " + node.getNodeType() 
					+ "{" + node.getClass() + "}: {" + node.getTextContent() + "}");
		}
		Node child = node.getFirstChild();
		while (child != null) {
			processNode(child, prefix+"  ");
			child = child.getNextSibling();
		}
	}
	public void processNode(Node node) {
		processNode(node, "");
	}
}
