import java.io.File;
import java.io.IOException;
import java.util.Properties;

/**
 * Calls the required java tools in the right order
 */
public class Main {

	public static void main(String[] args) {
    Properties config = new Properties();
    try {
      FileUtils.loadConfig(config);
      String atsPath = config.get("ATSPath").toString();
      String deliverableATSPath = config.get("DeliverableATSPath").toString();
      System.out.println("Processing ATS from "+new File(atsPath).getCanonicalFile().getAbsolutePath()+" ...");
      System.out.println("Output ATS and Documents will be generated to "+new File(deliverableATSPath).getCanonicalFile().getAbsolutePath()+" ...");
    } catch (IOException e) {
      System.err.println("[ERROR] Cannot load config file or config file is incomplete.");
      return;
    }

    DeliverableGenerator.main(args);
		TestSuiteStructureGenerator.main(args);
		ICSProformaTableGenerator.main(args);
		TestPurposeGenerator.main(args);
		CoverageLister.main(args);
	}

}
