import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Logger {
	private File allLogFile;
	private File criticalLogFile;
	private BufferedWriter allOut;
	private BufferedWriter criticalOut;

	public Logger(File allLogFile, File criticalLogFile) {
		this.allLogFile = allLogFile;
		this.criticalLogFile = criticalLogFile;
	}

	public void init() {
		try {
			FileWriter allFStream = new FileWriter(allLogFile.getAbsolutePath());
			allOut = new BufferedWriter(allFStream);
			FileWriter criticalFStream = new FileWriter(criticalLogFile.getAbsolutePath());
			criticalOut = new BufferedWriter(criticalFStream);
			allOut.write("");
			criticalOut.write("");
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			allOut.close();
			criticalOut.close();
		} catch (IOException e) {
		}
	}

	public void writeScreen(String str) {
		System.out.println(str);
	}

	public void writeAll(String str) {
		try {
			FileWriter allFStream = new FileWriter(allLogFile.getAbsolutePath(),true);
			allOut = new BufferedWriter(allFStream);
			FileWriter criticalFStream = new FileWriter(criticalLogFile.getAbsolutePath(), true);
			criticalOut = new BufferedWriter(criticalFStream);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			allOut.write(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			allOut.close();
			criticalOut.close();
		} catch (IOException e) {
		}
	}

	public void writeCritical(String str) {
		try {
			FileWriter allFStream = new FileWriter(allLogFile.getAbsolutePath(),true);
			allOut = new BufferedWriter(allFStream);
			FileWriter criticalFStream = new FileWriter(criticalLogFile.getAbsolutePath(), true);
			criticalOut = new BufferedWriter(criticalFStream);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			criticalOut.write(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			allOut.close();
			criticalOut.close();
		} catch (IOException e) {
		}
	}

	public void finish() {
//		try {
//			allOut.close();
//			criticalOut.close();
//		} catch (IOException e) {
//		}
	}
}
