import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DeliverableGenerator {

	private static final String[] IGNORED_FILES = {".svn", ".git", ".externalToolBuilders", ".settings", "bin", "ttcn3build"};
	private static Set<String> ignoredFiles = new HashSet<String>(Arrays.asList(IGNORED_FILES));
	
	public static Properties config = new Properties();
	public static Properties references = new Properties();
	
	public static void generateDeliverableDirectory(File sf, File tf) {
		if (sf.isDirectory()) {
			File newDir = new File(tf.getAbsolutePath() + "/" + sf.getName());
			if (ignoredFiles.contains(sf.getName()))
				return;
						
			newDir.mkdir();
			String[] children = sf.list();
			for (int i = 0; i < children.length; i++) {
				generateDeliverableDirectory(new File(sf, children[i]), newDir);
			}
		} else {
			if (sf.toString().endsWith(".ttcn")) {
				File newDir = new File(tf.getAbsolutePath() + "/" + sf.getName().replaceAll(".ttcn", ""));
				newDir.mkdir();
				
				try {
					int moduleCount = FileUtils.countT3Modules(sf);					
					if (moduleCount <= 1) {
						File targetFile = new File(newDir + "/" + sf.getName());
						FileUtils.copyFile(sf, targetFile);
					} else {
						File targetFile = new File(newDir + "/temp.ttcn");
						FileUtils.copyFile(sf, targetFile);
						FileUtils.splitT3ModuleFiles(targetFile);
						targetFile.delete();
					}
					
					
				} catch (IOException e) {
					e.printStackTrace();
				}
//				FileUtils.countT3Modules(f)
//				copyFile();
//				System.out.println(sf.toString());
			}
		}
	}
	
	// -----------------------------------------------------------------------------------------------

	public void run() {
		System.out.println("STF475 Tools: ATS Deliverable Generator v0.1");
		try {
			FileUtils.loadConfig(config);
			FileUtils.loadReferences(references);
		} catch (IOException e) {
			System.err
					.println("[ERROR] Cannot load config file or config file is incomplete.");
			return;
		}
		
		String atsPath = config.get("ATSPath").toString();
		String deliverablePath = config.get("DeliverableATSPath").toString();
		
		File deliverable = new File(deliverablePath);
		deliverable.mkdirs();

		generateDeliverableDirectory(new File(atsPath), deliverable);
		
//		List<Clause> myList = new ArrayList<Clause>();
//		Iterator<Object> it = references.keySet().iterator();
//		System.out.println("----");
//		while (it.hasNext()) {
//			Object value = it.next();
//			if (value instanceof String) {
//				myList.add(new Clause((String) value));
//			}
//		}
//		
//		Collections.sort(myList);

//		String atsPath = config.get("ATSPath").toString();
//		System.out.println("Gathering files...");
//		FileUtils.visitAllFiles(new File(atsPath), files);
//
//		System.out.println("Processing files...");
//
//		for (int i=0; i < files.size(); i++) {
//			File tempFile = new File(config.get("TempPath") + "/" + files.get(i).getName());
//		}
		
		System.out.println("done.");
	}

	// -----------------------------------------------------------------------------------------------

	public static void main(String[] args) {
		new DeliverableGenerator().run();
	}

}
