/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AbstractXTriReplyMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciParameterList;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.ExternalTciValueList;
import org.elvior.ttcn.tritci.TciParameterRefList;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TciValueRefList;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriSignatureIdImpl;
import org.etsi.ttcn.tri.TriStatus;
import org.etsi.ttcn.xtri.xTriCommunicationSA;

class XTriReplyMCMessage
extends AbstractXTriReplyMessage {
    private TciValueRefList m_addrList;

    public XTriReplyMCMessage() {
        this.m_addrList = new TciValueRefList();
    }

    public XTriReplyMCMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TriSignatureIdImpl signId, TciParameterRefList paramList, TciValueRef retVal, TciValueRefList addrList) {
        super(comp, systemPort, signId, paramList, retVal);
        this.m_addrList = addrList;
    }

    public TciValueRefList getAddressList() {
        return this.m_addrList;
    }

    @Override
    protected void serializeAddress(ByteArrayOutputStream ms) {
        this.m_addrList.serialize(ms);
    }

    @Override
    protected void deserializeAddress(ByteArrayInputStream ms) {
        this.m_addrList.deserialize(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.XReplyMC;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new XTriReplyMCMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() instanceof xTriCommunicationSA;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        ExternalTciParameterList paramList = new ExternalTciParameterList(this.getParameterList());
        ExternalTciValue retVal = null;
        if (this.getReturnValue() != null) {
            retVal = this.getReturnValue().createValue();
        }
        ExternalTciValueList addrList = new ExternalTciValueList(this.m_addrList);
        TriStatus status = ((xTriCommunicationSA)((Object)TriProvider.getInstance().getTriCommunicationSA())).xtriReplyMC(this.getComponentId(), this.getSystemPortId(), addrList, this.getSignatureId(), paramList, retVal);
        return new AdapterProcessingResult(status);
    }
}

