/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriBooleanImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriTimerIdImpl;
import org.elvior.ttcn.tritci.TriTimerRunningAckMessage;
import org.etsi.ttcn.tri.TriStatus;

class TriTimerRunningMessage
extends AbstractTriTciMessage {
    private TriTimerIdImpl m_timerId;
    private TriBooleanImpl m_running;

    public TriTimerRunningMessage(TriTimerIdImpl timerId, TriBooleanImpl running) {
        this.m_timerId = timerId;
        this.m_running = running;
    }

    public TriTimerRunningMessage() {
        this.m_timerId = new TriTimerIdImpl();
        this.m_running = new TriBooleanImpl();
    }

    public TriTimerIdImpl getTimerId() {
        return this.m_timerId;
    }

    public TriBooleanImpl isRunning() {
        return this.m_running;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TimerRunning;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_timerId.deserialize(ms);
        this.m_running.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_timerId.serialize(ms);
        this.m_running.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriTimerRunningMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status;
        TriBooleanImpl running = new TriBooleanImpl();
        try {
            status = TriProvider.getInstance().getTriPlatformPA().triTimerRunning(this.getTimerId(), running);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        TriTimerRunningAckMessage ack = new TriTimerRunningAckMessage(status.getStatus(), running);
        return new AdapterProcessingResult(status, ack);
    }
}

