/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriProvider;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriTimerDurationImpl;
import org.elvior.ttcn.tritci.TriTimerIdImpl;
import org.elvior.ttcn.tritci.TriTimerReadAckMessage;
import org.etsi.ttcn.tri.TriStatus;

class TriTimerReadMessage
extends AbstractTriTciMessage {
    private TriTimerIdImpl m_timerId;
    private TriTimerDurationImpl m_timerDuration;

    public TriTimerReadMessage(TriTimerIdImpl timerId, TriTimerDurationImpl timerDuration) {
        this.m_timerId = timerId;
        this.m_timerDuration = timerDuration;
    }

    public TriTimerReadMessage() {
        this.m_timerId = new TriTimerIdImpl();
        this.m_timerDuration = new TriTimerDurationImpl();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TimerRead;
    }

    public TriTimerIdImpl getTimerId() {
        return this.m_timerId;
    }

    public TriTimerDurationImpl getDuration() {
        return this.m_timerDuration;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_timerId.deserialize(ms);
        this.m_timerDuration.deserialize(ms);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_timerId.serialize(ms);
        this.m_timerDuration.serialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriTimerReadMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status;
        TriTimerDurationImpl timerDuration = new TriTimerDurationImpl();
        try {
            status = TriProvider.getInstance().getTriPlatformPA().triReadTimer(this.getTimerId(), timerDuration);
        }
        catch (Exception e) {
            status = TriStatusImpl.error();
        }
        TriTimerReadAckMessage ack = new TriTimerReadAckMessage(status.getStatus(), timerDuration);
        return new AdapterProcessingResult(status, ack);
    }
}

