/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.util.Stack;
import java.util.Vector;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriTciCallData;

class TriTciCallStack {
    private Vector<LocalCallStack> m_lItems = new Vector();

    TriTciCallStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveRemoteId(AbstractTriTciMessage msg, boolean bServer) {
        int nRemoteId = bServer ? msg.getClientChannelId() : msg.getServerChannelId();
        int nLocalId = bServer ? msg.getServerChannelId() : msg.getClientChannelId();
        long nThreadId = Thread.currentThread().getId();
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            if (nLocalId == -1) {
                LocalCallStack lcs = new LocalCallStack();
                lcs.setRemoteId(nRemoteId);
                lcs.setThreadId(nThreadId);
                int i = 0;
                while (nLocalId < 0 && i < this.m_lItems.size()) {
                    if (this.m_lItems.get(i) == null) {
                        nLocalId = i;
                        this.m_lItems.set(i, lcs);
                    }
                    ++i;
                }
                if (nLocalId < 0) {
                    nLocalId = this.m_lItems.size();
                    this.m_lItems.add(lcs);
                }
            } else {
                LocalCallStack lcs = this.m_lItems.get(nLocalId);
                lcs.setThreadId(nThreadId);
                if (lcs.getRemoteId() == -1) {
                    lcs.setRemoteId(nRemoteId);
                } else if (lcs.getRemoteId() != nRemoteId) {
                    throw new RuntimeException("Invalid channel ID");
                }
            }
        }
        return nLocalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCommunicationIds(AbstractTriTciMessage msg, boolean bServer, boolean bPop) {
        long nThreadId = Thread.currentThread().getId();
        int nRemoteId = -1;
        int nLocalId = -1;
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            int nFirstFreeIndex = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs == null) {
                    if (nFirstFreeIndex < 0) {
                        nFirstFreeIndex = i;
                    }
                } else if (lcs.getThreadId() == nThreadId) {
                    nLocalId = i;
                    nRemoteId = lcs.getRemoteId();
                }
                ++i;
            }
            if (nLocalId < 0) {
                LocalCallStack lcs = new LocalCallStack();
                lcs.setInternal(true);
                lcs.setThreadId(nThreadId);
                lcs.setRemoteId(-1);
                if (nFirstFreeIndex < 0) {
                    nLocalId = this.m_lItems.size();
                    this.m_lItems.add(lcs);
                } else {
                    nLocalId = nFirstFreeIndex;
                    this.m_lItems.set(nLocalId, lcs);
                }
            }
            if (bPop) {
                this.onAck(nLocalId);
            }
        }
        if (bServer) {
            msg.setServerChannelId(nLocalId);
            msg.setClientChannelId(nRemoteId);
        } else {
            msg.setClientChannelId(nLocalId);
            msg.setServerChannelId(nRemoteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriTciCallData registerCall(AbstractTriTciMessage msg, ETriTciMessageCode requiredAck, int nWaitingTime, boolean bServer) {
        this.fillCommunicationIds(msg, bServer, false);
        TriTciCallData res = new TriTciCallData(requiredAck, nWaitingTime);
        int nLocalId = bServer ? msg.getServerChannelId() : msg.getClientChannelId();
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            LocalCallStack lcs = this.m_lItems.get(nLocalId);
            Stack<TriTciCallData> stack = lcs.getStack();
            if (!stack.isEmpty()) {
                stack.peek().suspendWaiting();
            }
            stack.push(res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAck(int nLocalId) {
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            LocalCallStack lcs;
            if (nLocalId < this.m_lItems.size() && (lcs = this.m_lItems.get(nLocalId)) != null) {
                Stack<TriTciCallData> stack = lcs.getStack();
                if (stack.isEmpty()) {
                    this.m_lItems.set(nLocalId, null);
                } else {
                    this.m_lItems.get(nLocalId).setThreadId(-1L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptMessage(AbstractTriTciMessage msg, boolean bServer) {
        int nLocalId = bServer ? msg.getServerChannelId() : msg.getClientChannelId();
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            block6: {
                Stack<TriTciCallData> stack;
                LocalCallStack item = null;
                if (nLocalId >= 0 && nLocalId < this.m_lItems.size()) {
                    item = this.m_lItems.get(nLocalId);
                }
                if (item == null || (stack = item.getStack()).isEmpty()) break block6;
                TriTciCallData callData = stack.peek();
                if (stack.size() == 1 && item.isInternal() && item.getError() != null) {
                    callData.setError(item.getError());
                }
                if (!callData.accept(msg)) break block6;
                this.unregisterProc(stack, nLocalId);
                return true;
            }
        }
        return false;
    }

    private void unregisterProc(Stack<TriTciCallData> stack, int nLocalId) {
        stack.pop();
        if (stack.isEmpty()) {
            if (this.m_lItems.get(nLocalId).isInternal()) {
                this.m_lItems.set(nLocalId, null);
            }
        } else {
            stack.peek().restartWaiting();
            this.m_lItems.get(nLocalId).setThreadId(Thread.currentThread().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalCallStack getStackForCurrentThread() {
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            long nThreadId = Thread.currentThread().getId();
            int nLocalId = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs != null && lcs.getThreadId() == nThreadId) {
                    return lcs;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCall() {
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            long nThreadId = Thread.currentThread().getId();
            int nLocalId = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs != null && lcs.getThreadId() == nThreadId) {
                    this.unregisterProc(this.m_lItems.get(i).getStack(), i);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TriTciCallStack triTciCallStack = this;
        synchronized (triTciCallStack) {
            for (LocalCallStack item : this.m_lItems) {
                if (item == null) continue;
                Stack<TriTciCallData> stack = item.getStack();
                while (!stack.isEmpty()) {
                    stack.pop().stop();
                }
            }
            this.m_lItems.clear();
        }
    }

    public boolean isInCall() {
        LocalCallStack lcs = this.getStackForCurrentThread();
        return lcs != null && !lcs.getStack().isEmpty();
    }

    public void setError(String s) {
        LocalCallStack lcs = this.getStackForCurrentThread();
        if (lcs != null) {
            lcs.setError(s);
        }
    }

    private class LocalCallStack {
        private Stack<TriTciCallData> m_stack = new Stack();
        private String m_sError;
        private int m_nRemoteId;
        private long m_nThreadId;
        private boolean m_bInternal = false;

        public Stack<TriTciCallData> getStack() {
            return this.m_stack;
        }

        public String getError() {
            return this.m_sError;
        }

        public void setError(String sError) {
            this.m_sError = sError;
        }

        public long getThreadId() {
            return this.m_nThreadId;
        }

        public void setThreadId(long nId) {
            this.m_nThreadId = nId;
        }

        public int getRemoteId() {
            return this.m_nRemoteId;
        }

        public void setRemoteId(int nId) {
            this.m_nRemoteId = nId;
        }

        public boolean isInternal() {
            return this.m_bInternal;
        }

        public void setInternal(boolean bInternal) {
            this.m_bInternal = bInternal;
        }
    }
}

