/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;

class TriStartClockMessage
extends AbstractTriTciMessage {
    private long m_nTicksPerSec;

    public TriStartClockMessage() {
    }

    public TriStartClockMessage(long nTicksPerSec) {
        this.m_nTicksPerSec = nTicksPerSec;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriStartClockMessage();
    }

    public long getTicksPerSecond() {
        return this.m_nTicksPerSec;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriPlatformPA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriPlatformPA().triStartClock((int)this.m_nTicksPerSec);
        return new AdapterProcessingResult(status);
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        TriStartClockMessage.writeLong(ms, this.m_nTicksPerSec);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_nTicksPerSec = TriStartClockMessage.readLong(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.StartClock;
    }
}

