/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriCommOperation;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriMessageImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;

class TriSetStreamValueMessage
extends AbstractTriCommOperation {
    private TriMessageImpl m_streamValue;

    public TriSetStreamValueMessage() {
        this.m_streamValue = new TriMessageImpl();
    }

    public TriSetStreamValueMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TriMessageImpl streamValue) {
        super(comp, systemPort);
        this.m_streamValue = streamValue;
    }

    public TriMessageImpl getStreamValue() {
        return this.m_streamValue;
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriCommunicationSA().triSetStreamValue(this.getComponentId(), this.getSystemPortId(), null, this.m_streamValue);
        return new AdapterProcessingResult(status);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriSetStreamValueMessage();
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_streamValue.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_streamValue.deserialize(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.SetStreamValue;
    }
}

