/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.elvior.ttcn.tritci.AbstractTriSendMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriAddressListImpl;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriMessageImpl;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.elvior.ttcn.tritci.TriProvider;
import org.etsi.ttcn.tri.TriStatus;

class TriSendMCMessage
extends AbstractTriSendMessage {
    private TriAddressListImpl m_addr;

    public TriSendMCMessage() {
        this.m_addr = new TriAddressListImpl();
    }

    public TriSendMCMessage(TriComponentIdImpl comp, TriPortIdImpl systemPort, TriAddressListImpl addr, TriMessageImpl msg) {
        super(comp, systemPort, msg);
        this.m_addr = addr;
    }

    public TriAddressListImpl getAddressList() {
        return this.m_addr;
    }

    @Override
    protected void deserializeAddress(ByteArrayInputStream ms) {
        this.m_addr.deserialize(ms);
    }

    @Override
    protected void serializeAddress(ByteArrayOutputStream ms) {
        this.m_addr.serialize(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.SendMC;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TriSendMCMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TriProvider.getInstance().getTriCommunicationSA() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TriStatus status = TriProvider.getInstance().getTriCommunicationSA().triSendMC(this.getComponentId(), this.getSystemPortId(), this.m_addr, this.getMessage());
        return new AdapterProcessingResult(status);
    }
}

