/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.elvior.ttcn.tritci.TriAddressImpl;
import org.etsi.ttcn.tri.TriAddress;
import org.etsi.ttcn.tri.TriAddressList;

class TriAddressListImpl
extends AbstractTriTciClass
implements TriAddressList {
    private Vector<TriAddress> m_alAddresses = new Vector();

    public TriAddressListImpl(Vector<TriAddress> aAddresses) {
        if (aAddresses != null) {
            this.m_alAddresses.addAll(aAddresses);
        }
    }

    public TriAddressListImpl() {
        this(null);
    }

    @Override
    public void add(TriAddress addr) {
        this.m_alAddresses.add(addr);
    }

    @Override
    public void clear() {
        this.m_alAddresses.clear();
    }

    @Override
    public TriAddress get(int index) {
        return (TriAddress)this.m_alAddresses.toArray()[index];
    }

    @Override
    public Enumeration<TriAddress> getAddresses() {
        return this.m_alAddresses.elements();
    }

    @Override
    public boolean isEmpty() {
        return this.m_alAddresses.size() == 0;
    }

    @Override
    public int size() {
        return this.m_alAddresses.size();
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        int nLen = TriAddressListImpl.readInt(ms);
        this.m_alAddresses.clear();
        int i = 0;
        while (i < nLen) {
            TriAddressImpl addr = new TriAddressImpl();
            addr.deserialize(ms);
            this.m_alAddresses.add(addr);
            ++i;
        }
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        TriAddressListImpl.writeInt(ms, this.m_alAddresses.size());
        int i = 0;
        while (i < this.m_alAddresses.size()) {
            TriAddress o = this.m_alAddresses.get(i);
            TriAddressImpl addr = o instanceof TriAddressImpl ? (TriAddressImpl)o : new TriAddressImpl(o.getEncodedAddress());
            addr.serialize(ms);
            ++i;
        }
    }
}

