/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.ExternalTciValueDifferenceList;
import org.elvior.ttcn.tritci.SimpleTciValueTemplate;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciValueDifferenceRefList;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TliAbstractMatchMessage;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;

class TliMatchMismatchMessage
extends TliAbstractMatchMessage {
    private TciValueDifferenceRefList m_diff;

    public TliMatchMismatchMessage(String am, long ts, String src, int line, TriComponentIdImpl c, TciValueRef val, SimpleTciValueTemplate tmpt, TciValueDifferenceRefList diff) {
        super(am, ts, src, line, c, val, tmpt);
        this.m_diff = diff;
    }

    public TliMatchMismatchMessage() {
    }

    public TciValueDifferenceRefList getDifferences() {
        return this.m_diff;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_diff.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_diff = new TciValueDifferenceRefList();
        this.m_diff.deserialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TliMatchMismatchMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TliMatchMismatch;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        if (!this.isSupportedInAdapter()) {
            return new AdapterProcessingResult(TriStatusImpl.error());
        }
        TciProvider.getInstance().getTciTLProvided().tliMatchMismatch(this.getDetails(), this.getTimeStampInSeconds(), this.getFile(), this.getLine(), this.getComponentId(), this.getValue(), this.getTemplate(), new ExternalTciValueDifferenceList(this.getDifferences()));
        return new AdapterProcessingResult(TriStatusImpl.ok());
    }
}

