/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.elvior.ttcn.tritci.ExternalTciType;
import org.etsi.ttcn.tci.TciParameterType;
import org.etsi.ttcn.tci.Type;

class TciParameterTypeImpl
extends AbstractTriTciClass
implements TciParameterType {
    private int m_nMode;
    private long m_nTypeId;
    private ExternalTciType m_type;

    public TciParameterTypeImpl(long nTypeId, int nMode) {
        this.m_nTypeId = nTypeId;
        if (nMode != 0 || nMode != 1 || nMode != 2) {
            throw new IllegalArgumentException("Invalid parameter value");
        }
        this.m_nMode = nMode;
    }

    public TciParameterTypeImpl() {
    }

    @Override
    public Type getParameterType() {
        return this.m_type;
    }

    @Override
    public int getParameterPassingMode() {
        return this.m_nMode;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        TciParameterTypeImpl.writeLong(ms, this.m_nTypeId);
        ms.write(this.m_nMode);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        this.m_nTypeId = TciParameterTypeImpl.readLong(ms);
        this.m_type = new ExternalTciType(this.m_nTypeId);
        this.m_nMode = TciParameterTypeImpl.readByte(ms);
    }
}

