/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.etsi.ttcn.tri.TriComponentId;

class TciLogMessage
extends AbstractTriTciMessage {
    private String m_sMsg;
    private TriComponentIdImpl m_compId;

    public TciLogMessage(TriComponentId compId, String sMsg) {
        if (compId == null) {
            throw new NullPointerException();
        }
        this.m_compId = compId instanceof TriComponentIdImpl ? (TriComponentIdImpl)compId : new TriComponentIdImpl(compId);
        this.m_sMsg = sMsg;
    }

    public TciLogMessage() {
    }

    public String getMessage() {
        return this.m_sMsg;
    }

    public TriComponentIdImpl getComponentId() {
        return this.m_compId;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_compId.serialize(ms);
        TciLogMessage.writeString(ms, this.m_sMsg);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_compId = new TriComponentIdImpl();
        this.m_compId.deserialize(ms);
        this.m_sMsg = TciLogMessage.readString(ms);
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TciLog;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TciLogMessage();
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciTMProvided() != null;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        TciProvider.getInstance().getTciTMProvided().tciLog(this.getComponentId(), this.m_sMsg);
        return new AdapterProcessingResult(TriStatusImpl.ok());
    }
}

