/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.elvior.ttcn.tritci.TciObjIdElementImpl;
import org.etsi.ttcn.tci.TciObjId;
import org.etsi.ttcn.tci.TciObjIdElement;

class SimpleTciObjid
extends AbstractTriTciClass
implements TciObjId {
    private Vector<TciObjIdElementImpl> m_lObj = new Vector();

    public SimpleTciObjid() {
    }

    public SimpleTciObjid(TciObjId source) {
        int nLen = source.size();
        if (nLen > 0) {
            this.m_lObj.ensureCapacity(nLen);
        }
        int i = 0;
        while (i < nLen) {
            this.add(source.getObjElement(i));
            ++i;
        }
    }

    private void add(TciObjIdElement item) {
        if (item instanceof TciObjIdElementImpl) {
            this.m_lObj.add((TciObjIdElementImpl)item);
        } else {
            this.m_lObj.add(new TciObjIdElementImpl(item));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TciObjId) {
            TciObjId value = (TciObjId)obj;
            int nLen = this.size();
            if (nLen == value.size()) {
                int i = 0;
                while (i < nLen) {
                    if (this.m_lObj.get(i).getElementAsNumber() != value.getObjElement(i).getElementAsNumber()) {
                        return false;
                    }
                    if (this.m_lObj.get(i).getElementAsAscii() != value.getObjElement(i).getElementAsAscii()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int size() {
        return this.m_lObj.size();
    }

    @Override
    public TciObjIdElement getObjElement(int index) {
        return this.m_lObj.get(index);
    }

    @Override
    public void setObjElement(TciObjIdElement[] objElements) {
        this.m_lObj.clear();
        if (objElements.length > 0) {
            this.m_lObj.ensureCapacity(objElements.length);
        }
        int i = 0;
        while (i < objElements.length) {
            this.add(objElements[i]);
            ++i;
        }
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        int nCount = this.m_lObj.size();
        SimpleTciObjid.writeInt(ms, nCount);
        int i = 0;
        while (i < nCount) {
            this.m_lObj.get(i).serialize(ms);
            ++i;
        }
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        this.m_lObj.clear();
        int nLen = SimpleTciObjid.readInt(ms);
        this.m_lObj.ensureCapacity(nLen);
        int i = 0;
        while (i < nLen) {
            TciObjIdElementImpl elem = new TciObjIdElementImpl();
            elem.deserialize(ms);
            this.m_lObj.add(elem);
            ++i;
        }
    }
}

