/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ExternalTciParameterList;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.ExternalTciValueDifferenceList;
import org.elvior.ttcn.tritci.TciParameterRefList;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciValueDifferenceRefList;
import org.elvior.ttcn.tritci.TciValueRef;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.etsi.ttcn.tri.TriComponentId;

public abstract class AbstractTliMessage
extends AbstractTriTciMessage {
    private String m_am;
    private String m_src;
    private long m_ts;
    private int m_nLine;
    private TriComponentIdImpl m_comp;

    protected AbstractTliMessage(String am, long ts, String src, int line, TriComponentIdImpl c) {
        this.m_am = am;
        this.m_ts = ts;
        this.m_src = src;
        this.m_nLine = line;
        this.m_comp = c;
    }

    protected AbstractTliMessage() {
    }

    public String getDetails() {
        return this.m_am;
    }

    public long getTimeStamp() {
        return this.m_ts;
    }

    public int getTimeStampInSeconds() {
        return (int)(this.m_ts / 1000L);
    }

    public String getFile() {
        return this.m_src;
    }

    public int getLine() {
        return this.m_nLine;
    }

    public TriComponentId getComponentId() {
        return this.m_comp;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        AbstractTliMessage.writeUString(ms, this.m_am);
        AbstractTliMessage.writeLong(ms, this.m_ts);
        AbstractTliMessage.writeUString(ms, this.m_src);
        AbstractTliMessage.writeInt(ms, this.m_nLine);
        this.writeOptionalObject(this.m_comp, ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_am = AbstractTliMessage.readOptUString(ms);
        this.m_ts = AbstractTliMessage.readLong(ms);
        this.m_src = AbstractTliMessage.readOptUString(ms);
        this.m_nLine = AbstractTliMessage.readInt(ms);
        this.m_comp = this.readOptionalObject(ms, TriComponentIdImpl.class);
    }

    protected ExternalTciValue createOptValue(TciValueRef valRef) {
        if (valRef == null) {
            return null;
        }
        return valRef.createValue();
    }

    protected ExternalTciParameterList createOptParams(TciParameterRefList paramRef) {
        if (paramRef == null) {
            return null;
        }
        return new ExternalTciParameterList(paramRef);
    }

    protected ExternalTciValueDifferenceList createOptDiffs(TciValueDifferenceRefList diffRef) {
        if (diffRef == null) {
            return null;
        }
        return new ExternalTciValueDifferenceList(diffRef);
    }

    @Override
    public boolean isSupportedInAdapter() {
        return TciProvider.getInstance().getTciTLProvided() != null;
    }
}

