/*
 * Decompiled with CFR 0.152.
 */
package com.testingtech.tri.extfct;

import com.testingtech.ttcn.annotation.ExternalFunction;
import com.testingtech.ttcn.tri.AnnotationsExternalFunctionPlugin;
import com.testingtech.util.FileUtil;
import de.tu_berlin.cs.uebb.muttcn.runtime.TestCaseError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.etsi.mts.ttcn.part9.xmldiff.XmlDiff;
import org.etsi.ttcn.tci.BooleanValue;
import org.etsi.ttcn.tci.RecordOfValue;
import org.etsi.ttcn.tci.UniversalCharstringValue;

@ExternalFunction.Definitions(value={XmlDiffExtFctPlugin.class})
public class XmlDiffExtFctPlugin
extends AnnotationsExternalFunctionPlugin {
    @ExternalFunction(name="matchFile")
    public BooleanValue matchFile(UniversalCharstringValue p_textToMatch, UniversalCharstringValue p_referenceXmlFile, RecordOfValue xsdFileList, UniversalCharstringValue p_matchError, UniversalCharstringValue p_referenceTTCN3File) {
        String stringToMatch = p_textToMatch.getString();
        File parentFolder = new File(p_referenceTTCN3File.getString()).getAbsoluteFile().getParentFile();
        String strReferenceXmlFile = p_referenceXmlFile.getString();
        strReferenceXmlFile = new File(parentFolder, strReferenceXmlFile).getAbsolutePath();
        String[] xsdFileArray = null;
        if (xsdFileList.getLength() > 0) {
            xsdFileArray = new String[xsdFileList.getLength()];
            int i = 0;
            while (i < xsdFileList.getLength()) {
                xsdFileArray[i] = ((UniversalCharstringValue)xsdFileList.getField(i)).getString();
                ++i;
            }
        }
        String description = "";
        boolean res = false;
        try {
            XmlDiff diff = new XmlDiff(strReferenceXmlFile, xsdFileArray, new String[]{parentFolder.getAbsolutePath()});
            StringBuilder sb = new StringBuilder();
            res = diff.diff(stringToMatch, sb);
            if (sb.length() > 0) {
                description = sb.toString();
            }
        }
        catch (Exception e) {
            description = e.getMessage();
        }
        if (!res && description == null) {
            description = "Unspecified error";
        }
        p_matchError.setString(description);
        return this.newBooleanValue(res);
    }

    @ExternalFunction(name="readFile")
    public UniversalCharstringValue readFile(UniversalCharstringValue p_referenceXmlFile, UniversalCharstringValue p_referenceTTCN3File) {
        FileInputStream in = null;
        try {
            File referenceTTCN3File = new File(p_referenceTTCN3File.getString());
            String strReferenceXmlFile = p_referenceXmlFile.getString();
            File file = new File(referenceTTCN3File.getAbsoluteFile().getParentFile(), strReferenceXmlFile);
            in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            FileUtil.copy((InputStream)in, (OutputStream)out);
            UniversalCharstringValue universalCharstringValue = this.newUniversalCharstringValue(out.toString("UTF-8"));
            return universalCharstringValue;
        }
        catch (Throwable e) {
            throw new TestCaseError((Throwable)new RuntimeException(MessageFormat.format("error while reading UTF-8 encoded file: {0} {1}", p_referenceXmlFile.getString(), e.toString()), e));
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

