/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TestSuiteStructureGenerator {
    public static Properties config = new Properties();
    public static Properties references = new Properties();
    private ArrayList<File> files = new ArrayList();
    private HashMap<String, ArrayList<ClauseEntry>> clauseMapPositive = new HashMap();
    private HashMap<String, ArrayList<ClauseEntry>> clauseMapNegative = new HashMap();

    public void run() {
        System.out.println("STF475 Tools: Test Suite Structure Tables Generator v0.1");
        try {
            FileUtils.loadConfig(config);
            FileUtils.loadReferences(references);
        }
        catch (IOException e) {
            System.err.println("[ERROR] Cannot load config file or config file is incomplete.");
            return;
        }
        ArrayList<Clause> myList = new ArrayList<Clause>();
        Iterator<Object> it = references.keySet().iterator();
        System.out.println("----");
        while (it.hasNext()) {
            Object value = it.next();
            if (!(value instanceof String)) continue;
            myList.add(new Clause((String)value));
        }
        Collections.sort(myList);
        try {
            String atsPath = config.get("ATSPath").toString();
            System.out.println("Gathering files...");
            FileUtils.visitAllFiles(new File(atsPath), this.files);
            System.out.println("Processing files...");
            int i = 0;
            while (i < this.files.size()) {
                ClauseEntry clauseEntry;
                ArrayList<ClauseEntry> clauseEntries;
                File tempFile = this.files.get(i);
                T3Purpose purpose = FileUtils.extractPurpose(tempFile);
                T3ExpectedOutput expected = FileUtils.extractExpectedOutput(tempFile);
                Clause clauseStructured = purpose.getClauseStructured();
                if (clauseStructured == null) {
                    throw new IOException("Error scanning structured clause for file " + tempFile + " purpose: " + purpose.toString());
                }
                if (this.files.get(i).getName().toLowerCase().startsWith("neg")) {
                    clauseEntries = this.clauseMapNegative.get(clauseStructured.toString());
                    if (clauseEntries == null) {
                        clauseEntries = new ArrayList();
                    }
                    clauseEntry = new ClauseEntry();
                    clauseEntry.setFile(tempFile);
                    clauseEntry.setPurpose(purpose);
                    clauseEntry.setExpected(expected);
                    clauseEntries.add(clauseEntry);
                    this.clauseMapNegative.put(clauseStructured.toString(), clauseEntries);
                } else {
                    clauseEntries = this.clauseMapPositive.get(clauseStructured.toString());
                    if (clauseEntries == null) {
                        clauseEntries = new ArrayList();
                    }
                    clauseEntry = new ClauseEntry();
                    clauseEntry.setFile(tempFile);
                    clauseEntry.setPurpose(purpose);
                    clauseEntry.setExpected(expected);
                    clauseEntries.add(clauseEntry);
                    this.clauseMapPositive.put(clauseStructured.toString(), clauseEntries);
                }
                ++i;
            }
            String tssFileHead = FileUtils.loadFileToString(new File("resources/tss-file-head.html"));
            String tssFileFooter = FileUtils.loadFileToString(new File("resources/tss-file-foot.html"));
            String tssSectionHead = FileUtils.loadFileToString(new File("resources/tss-section-head.html"));
            String tssSectionFoot = FileUtils.loadFileToString(new File("resources/tss-section-foot.html"));
            StringBuffer result = new StringBuffer();
            result.append(tssFileHead);
            this.createTable(myList, "B.1", "Test suite structure, positive tests", tssSectionHead, tssSectionFoot, this.clauseMapPositive, result);
            this.createTable(myList, "B.2", "Test suite structure, negative tests", tssSectionHead, tssSectionFoot, this.clauseMapNegative, result);
            result.append(tssFileFooter);
            FileUtils.saveStringToFile(new File(String.valueOf(config.getProperty("DeliverableATSPath")) + "/stf475-tss.html"), result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("done.");
    }

    private void createTable(List<Clause> myList, String tableNumber, String tableDescription, String tssSectionHead, String tssSectionFoot, HashMap<String, ArrayList<ClauseEntry>> clauseMap, StringBuffer result) {
        result.append(this.createSectionHead(tssSectionHead, tableNumber, tableDescription));
        TSSTable table = new TSSTable();
        TSSRow row = null;
        int i = 0;
        while (i < myList.size()) {
            ClauseEntry entry;
            int j;
            TSSClause tssClause;
            Clause clause = myList.get(i);
            ArrayList<ClauseEntry> clauseEntries = null;
            if (!clause.toString().contains(".")) {
                if (row != null) {
                    table.addRow(row);
                    row = null;
                }
                clauseEntries = clauseMap.get(clause.toString());
                row = new TSSRow();
                row.setChapter(String.valueOf(clause.toString()) + " " + references.getProperty(clause.toString()));
                if (clauseEntries != null && clauseEntries.size() > 0) {
                    tssClause = new TSSClause();
                    tssClause.setClauseName("Top level");
                    j = 0;
                    while (j < clauseEntries.size()) {
                        entry = clauseEntries.get(j);
                        tssClause.addTestCase(entry.getFile().getName().replaceAll("\\.ttcn", ""));
                        ++j;
                    }
                    row.addClause(tssClause);
                }
            } else {
                clauseEntries = clauseMap.get(clause.toString());
                if (clauseEntries != null && clauseEntries.size() > 0) {
                    tssClause = new TSSClause();
                    tssClause.setClauseName(String.valueOf(clause.toString()) + " " + references.getProperty(clause.toString()));
                    j = 0;
                    while (j < clauseEntries.size()) {
                        entry = clauseEntries.get(j);
                        tssClause.addTestCase(entry.getFile().getName().replaceAll("\\.ttcn", ""));
                        ++j;
                    }
                    row.addClause(tssClause);
                }
            }
            ++i;
        }
        result.append(table.toHtml());
        result.append(tssSectionFoot);
    }

    private String createSectionHead(String sectionHead, String tableNumber, String tableDescription) {
        String newSectionHead = sectionHead.replaceAll("\\{\\{TABLENUMBER\\}\\}", tableNumber);
        newSectionHead = newSectionHead.replaceAll("\\{\\{TABLEDESCRIPTION\\}\\}", tableDescription);
        return newSectionHead;
    }

    public static void main(String[] args) {
        new TestSuiteStructureGenerator().run();
    }
}

