/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.util.Stack;
import java.util.Vector;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriTciCallData;

class TriTciCallStack {
    private Object m_lock = new Object();
    private Vector<LocalCallStack> m_lItems = new Vector();

    TriTciCallStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveCommunicationIDs(AbstractTriTciMessage msg, boolean bServer) {
        int nRemoteId = bServer ? msg.getClientChannelId() : msg.getServerChannelId();
        int nLocalId = bServer ? msg.getServerChannelId() : msg.getClientChannelId();
        long nThreadId = Thread.currentThread().getId();
        Object object = this.m_lock;
        synchronized (object) {
            if (nLocalId == -1) {
                LocalCallStack lcs = new LocalCallStack();
                lcs.setRemoteId(nRemoteId);
                lcs.setThreadId(nThreadId);
                int i = 0;
                while (nLocalId < 0 && i < this.m_lItems.size()) {
                    if (this.m_lItems.get(i) == null) {
                        nLocalId = i;
                        this.m_lItems.set(i, lcs);
                    }
                    ++i;
                }
                if (nLocalId < 0) {
                    nLocalId = this.m_lItems.size();
                    this.m_lItems.add(lcs);
                }
            } else {
                LocalCallStack lcs = this.m_lItems.get(nLocalId);
                lcs.setThreadId(nThreadId);
                if (lcs.getRemoteId() == -1) {
                    lcs.setRemoteId(nRemoteId);
                } else if (lcs.getRemoteId() != nRemoteId) {
                    throw new RuntimeException("Invalid channel ID");
                }
            }
        }
        return nLocalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCommunicationIds(AbstractTriTciMessage msg, boolean bServer, boolean bUpdateThreadId, int nRequestedLocalId) {
        long nThreadId = Thread.currentThread().getId();
        int nRemoteId = -1;
        int nLocalId = -1;
        Object object = this.m_lock;
        synchronized (object) {
            int nFirstFreeIndex = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs == null) {
                    if (nFirstFreeIndex < 0) {
                        nFirstFreeIndex = i;
                    }
                } else if (lcs.getThreadId() == nThreadId && lcs.isThreadIdInUse() || i == nRequestedLocalId) {
                    nLocalId = i;
                    nRemoteId = lcs.getRemoteId();
                }
                ++i;
            }
            if (nLocalId < 0) {
                LocalCallStack lcs = new LocalCallStack();
                lcs.setInternal(true);
                lcs.setThreadId(nThreadId);
                lcs.setRemoteId(-1);
                if (nFirstFreeIndex < 0) {
                    nLocalId = this.m_lItems.size();
                    this.m_lItems.add(lcs);
                } else {
                    nLocalId = nFirstFreeIndex;
                    this.m_lItems.set(nLocalId, lcs);
                }
            }
            if (bUpdateThreadId) {
                this.updateThreadId(nLocalId);
            }
        }
        if (bServer) {
            msg.setServerChannelId(nLocalId);
            msg.setClientChannelId(nRemoteId);
        } else {
            msg.setClientChannelId(nLocalId);
            msg.setServerChannelId(nRemoteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriTciCallData registerCall(AbstractTriTciMessage msg, ETriTciMessageCode requiredAck, int nWaitingTime, boolean bServer, boolean bFill) {
        if (bFill) {
            this.fillCommunicationIds(msg, bServer, false, -1);
        }
        TriTciCallData res = new TriTciCallData(requiredAck, nWaitingTime);
        int nLocalId = bServer ? msg.getServerChannelId() : msg.getClientChannelId();
        Object object = this.m_lock;
        synchronized (object) {
            LocalCallStack lcs = this.m_lItems.get(nLocalId);
            Stack<TriTciCallData> stack = lcs.getStack();
            if (!stack.isEmpty()) {
                stack.peek().suspendWaiting();
            }
            stack.push(res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreadId(int nLocalId) {
        Object object = this.m_lock;
        synchronized (object) {
            LocalCallStack lcs;
            if (nLocalId < this.m_lItems.size() && nLocalId >= 0 && (lcs = this.m_lItems.get(nLocalId)) != null) {
                Stack<TriTciCallData> stack = lcs.getStack();
                if (stack.size() == 0) {
                    this.m_lItems.get(nLocalId).setThreadIdInUse(false);
                } else {
                    this.m_lItems.get(nLocalId).setThreadId(stack.peek().getThreadId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBlockedLocalId(int nLocalId) {
        Object object = this.m_lock;
        synchronized (object) {
            Stack<TriTciCallData> stack;
            LocalCallStack lcs;
            if (nLocalId < this.m_lItems.size() && nLocalId >= 0 && (lcs = this.m_lItems.get(nLocalId)) != null && (stack = lcs.getStack()).size() == 0) {
                this.m_lItems.set(nLocalId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptMessage(AbstractTriTciMessage msg) {
        int nLocalId = msg.getClientChannelId();
        Object object = this.m_lock;
        synchronized (object) {
            block6: {
                Stack<TriTciCallData> stack;
                LocalCallStack item = null;
                if (nLocalId >= 0 && nLocalId < this.m_lItems.size()) {
                    item = this.m_lItems.get(nLocalId);
                }
                if (item == null || (stack = item.getStack()).isEmpty()) break block6;
                TriTciCallData callData = stack.peek();
                if (stack.size() == 1 && item.isInternal() && item.getError() != null) {
                    callData.setError(item.getError());
                }
                if (!callData.accept(msg)) break block6;
                this.unregisterProc(stack, nLocalId);
                callData.signalAccept();
                return true;
            }
        }
        return false;
    }

    private void unregisterProc(Stack<TriTciCallData> stack, int nLocalId) {
        stack.pop();
        if (stack.isEmpty()) {
            if (this.m_lItems.get(nLocalId).isInternal()) {
                this.m_lItems.set(nLocalId, null);
            }
        } else {
            TriTciCallData tcd = stack.peek();
            tcd.restartWaiting();
            this.m_lItems.get(nLocalId).setThreadId(tcd.getThreadId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalCallStack getStackForCurrentThread() {
        Object object = this.m_lock;
        synchronized (object) {
            long nThreadId = Thread.currentThread().getId();
            int nLocalId = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs != null && lcs.getThreadId() == nThreadId && lcs.isThreadIdInUse()) {
                    return lcs;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCall() {
        Object object = this.m_lock;
        synchronized (object) {
            long nThreadId = Thread.currentThread().getId();
            int nLocalId = -1;
            int i = 0;
            while (nLocalId < 0 && i < this.m_lItems.size()) {
                LocalCallStack lcs = this.m_lItems.get(i);
                if (lcs != null && lcs.getThreadId() == nThreadId && lcs.isThreadIdInUse()) {
                    this.unregisterProc(this.m_lItems.get(i).getStack(), i);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_lock;
        synchronized (object) {
            for (LocalCallStack item : this.m_lItems) {
                if (item == null) continue;
                Stack<TriTciCallData> stack = item.getStack();
                while (!stack.isEmpty()) {
                    stack.pop().stop();
                }
            }
            this.m_lItems.clear();
        }
    }

    public boolean isInCall() {
        LocalCallStack lcs = this.getStackForCurrentThread();
        return lcs != null && !lcs.getStack().isEmpty();
    }

    public void setError(String s) {
        LocalCallStack lcs = this.getStackForCurrentThread();
        if (lcs != null) {
            lcs.setError(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStackSize(int nLocalId) {
        int nRes = 0;
        Object object = this.m_lock;
        synchronized (object) {
            LocalCallStack lcs;
            if (nLocalId < this.m_lItems.size() && nLocalId >= 0 && (lcs = this.m_lItems.get(nLocalId)) != null) {
                nRes = lcs.getStack().size();
            }
        }
        return nRes;
    }

    private class LocalCallStack {
        private Stack<TriTciCallData> m_stack = new Stack();
        private String m_sError;
        private int m_nRemoteId;
        private long m_nThreadId;
        private boolean m_bInternal = false;
        private boolean m_bThreadIdInUse = true;

        public Stack<TriTciCallData> getStack() {
            return this.m_stack;
        }

        public String getError() {
            return this.m_sError;
        }

        public void setError(String sError) {
            this.m_sError = sError;
        }

        public long getThreadId() {
            return this.m_nThreadId;
        }

        public void setThreadId(long nId) {
            this.m_nThreadId = nId;
        }

        public int getRemoteId() {
            return this.m_nRemoteId;
        }

        public void setRemoteId(int nId) {
            this.m_nRemoteId = nId;
        }

        public boolean isInternal() {
            return this.m_bInternal;
        }

        public void setInternal(boolean bInternal) {
            this.m_bInternal = bInternal;
        }

        public boolean isThreadIdInUse() {
            return this.m_bThreadIdInUse;
        }

        public void setThreadIdInUse(boolean bInUse) {
            this.m_bThreadIdInUse = bInUse;
        }
    }
}

