/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elvior.ttcn.tritci.AbstractTriAckMessage;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.StopWatch;

class TriTciCallData {
    private CountDownLatch m_evDone = new CountDownLatch(1);
    private CountDownLatch m_evAck = new CountDownLatch(1);
    private boolean m_bRestart = false;
    private AbstractTriAckMessage m_msg;
    private ETriTciMessageCode m_requiredAck;
    private int m_nWaitingTime;
    private String m_sError = null;
    private StopWatch m_watch = new StopWatch();
    private long m_nThreadId;

    public TriTciCallData(ETriTciMessageCode requiredAck, int nWaitingTime) {
        this.m_requiredAck = requiredAck;
        this.m_nWaitingTime = nWaitingTime;
        this.m_nThreadId = Thread.currentThread().getId();
    }

    public boolean accept(AbstractTriTciMessage msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        if (msg.getMessageCode() == this.m_requiredAck) {
            this.m_msg = (AbstractTriAckMessage)msg;
            return true;
        }
        return false;
    }

    public void signalAccept() {
        this.m_evAck.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.m_sError = null;
        TriTciCallData triTciCallData = this;
        synchronized (triTciCallData) {
            this.m_bRestart = false;
            this.m_evDone.countDown();
            this.m_evAck.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWaiting() {
        TriTciCallData triTciCallData = this;
        synchronized (triTciCallData) {
            this.m_evDone = new CountDownLatch(1);
        }
        this.m_watch.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartWaiting() {
        block5: {
            try {
                if (this.m_evDone.await(0L, TimeUnit.MILLISECONDS)) break block5;
                TriTciCallData triTciCallData = this;
                synchronized (triTciCallData) {
                    this.m_bRestart = true;
                    this.m_evDone.countDown();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractTriAckMessage waitForAck() {
        try {
            do {
                TriTciCallData triTciCallData = this;
                synchronized (triTciCallData) {
                    if (this.m_evDone.getCount() > 0L) {
                        this.m_evDone.countDown();
                    }
                    this.m_bRestart = false;
                }
                long nTime = (long)this.m_nWaitingTime - this.m_watch.getElapsedTime();
                if (nTime < 0L) {
                    return null;
                }
                this.m_watch.start();
                if (this.m_evAck.await(nTime, TimeUnit.MILLISECONDS)) {
                    return this.m_msg;
                }
                this.m_evDone.await();
            } while (this.m_bRestart);
            return null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public String getError() {
        return this.m_sError;
    }

    public void setError(String sError) {
        this.m_sError = sError;
    }

    public long getThreadId() {
        return this.m_nThreadId;
    }
}

