/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;

abstract class TriBinaryData
extends AbstractTriTciClass {
    private byte[] m_aData;
    private int m_nBits;
    private int m_nDecoderBitPosition;

    public TriBinaryData() {
    }

    public TriBinaryData(byte[] aData) {
        this(aData, aData == null ? 0 : aData.length * 8);
    }

    public TriBinaryData(byte[] aData, int nBitLen) {
        this.m_aData = aData;
        this.m_nBits = nBitLen;
    }

    public TriBinaryData(byte[] aData, int nBitLen, int nBitPosition) {
        this.m_aData = aData;
        this.m_nBits = nBitLen;
        this.m_nDecoderBitPosition = nBitPosition;
    }

    protected byte[] getData() {
        return this.m_aData;
    }

    protected void setData(byte[] value) {
        this.m_aData = value;
        this.m_nBits = this.m_aData == null ? 0 : this.m_aData.length * 8;
    }

    protected int getBits() {
        return this.m_nBits;
    }

    protected void setBits(int amount) {
        this.m_nBits = amount;
    }

    protected int getDecoderBitPosition() {
        return this.m_nDecoderBitPosition;
    }

    protected void setDecoderBitPosition(int nDecoderBitPosition) {
        this.m_nDecoderBitPosition = nDecoderBitPosition;
    }

    protected boolean compareBinaryData(byte[] aData) {
        if (aData.length != this.m_aData.length) {
            return false;
        }
        int i = 0;
        while (i < aData.length) {
            if (aData[i] != this.m_aData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TriBinaryData) {
            TriBinaryData o = (TriBinaryData)obj;
            if (this.getBits() != o.getBits()) {
                return false;
            }
            return this.compareBinaryData(o.m_aData);
        }
        return false;
    }

    protected boolean canSerializeBitPosition() {
        return false;
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        this.m_aData = TriBinaryData.readStream(ms);
        this.m_nBits = TriBinaryData.readInt(ms);
        if (this.canSerializeBitPosition()) {
            this.m_nDecoderBitPosition = TriBinaryData.readInt(ms);
        }
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        TriBinaryData.writeStream(ms, this.m_aData);
        TriBinaryData.writeInt(ms, this.m_nBits);
        if (this.canSerializeBitPosition()) {
            TriBinaryData.writeInt(ms, this.m_nDecoderBitPosition);
        }
    }
}

