/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciClass;
import org.elvior.ttcn.tritci.ExternalTciAddressValue;
import org.elvior.ttcn.tritci.ExternalTciBStringValue;
import org.elvior.ttcn.tritci.ExternalTciBooleanValue;
import org.elvior.ttcn.tritci.ExternalTciCStringValue;
import org.elvior.ttcn.tritci.ExternalTciCharValue;
import org.elvior.ttcn.tritci.ExternalTciDecMatch;
import org.elvior.ttcn.tritci.ExternalTciEnumValue;
import org.elvior.ttcn.tritci.ExternalTciFloatValue;
import org.elvior.ttcn.tritci.ExternalTciHStringValue;
import org.elvior.ttcn.tritci.ExternalTciIntegerValue;
import org.elvior.ttcn.tritci.ExternalTciMatchingList;
import org.elvior.ttcn.tritci.ExternalTciMatchingMechanism;
import org.elvior.ttcn.tritci.ExternalTciOStringValue;
import org.elvior.ttcn.tritci.ExternalTciObjidValue;
import org.elvior.ttcn.tritci.ExternalTciPattern;
import org.elvior.ttcn.tritci.ExternalTciRecordOfValue;
import org.elvior.ttcn.tritci.ExternalTciRecordValue;
import org.elvior.ttcn.tritci.ExternalTciUCharValue;
import org.elvior.ttcn.tritci.ExternalTciUStringValue;
import org.elvior.ttcn.tritci.ExternalTciUnionValue;
import org.elvior.ttcn.tritci.ExternalTciValue;
import org.elvior.ttcn.tritci.ExternalTciValueRange;
import org.elvior.ttcn.tritci.ExternalTciVerdictValue;
import org.elvior.ttcn.tritci.Logger;
import org.elvior.ttcn.tritci.TriTciChannel;

class TciValueRef
extends AbstractTriTciClass {
    public static final long EMPTY = Long.MAX_VALUE;
    private long m_nId = Long.MAX_VALUE;
    private int m_nType;
    private ExternalTciValue m_val;

    public void finalize() {
        if (this.m_nId == Long.MAX_VALUE) {
            return;
        }
        TriTciChannel.getInstance().unregisterTciObject(this.m_nId);
        Logger.getInstance().writeLine("TciValue reference unregistered; ID " + this.getId());
    }

    public long getId() {
        return this.m_nId;
    }

    public int getTypeClass() {
        return this.m_nType;
    }

    synchronized ExternalTciMatchingMechanism createValue(int nMatchingType) {
        if (this.m_nId == Long.MAX_VALUE) {
            return null;
        }
        if (this.m_val == null) {
            switch (nMatchingType) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 11: {
                    this.m_val = new ExternalTciMatchingMechanism(this, nMatchingType);
                    break;
                }
                case 0: 
                case 1: 
                case 5: 
                case 6: {
                    this.m_val = new ExternalTciMatchingList(this, nMatchingType);
                    break;
                }
                case 9: {
                    this.m_val = new ExternalTciPattern(this);
                    break;
                }
                case 10: {
                    this.m_val = new ExternalTciDecMatch(this);
                    break;
                }
                case 4: {
                    this.m_val = new ExternalTciValueRange(this);
                }
            }
        }
        return (ExternalTciMatchingMechanism)this.m_val;
    }

    synchronized ExternalTciValue createValue() {
        if (this.m_nId == Long.MAX_VALUE) {
            return null;
        }
        if (this.m_val == null) {
            int matchingType = TriTciChannel.getInstance().isMatching(this.m_nId);
            if (matchingType >= 0) {
                return this.createValue(matchingType);
            }
            switch (this.m_nType) {
                case 10: {
                    this.m_val = new ExternalTciIntegerValue(this);
                    break;
                }
                case 8: {
                    this.m_val = new ExternalTciFloatValue(this);
                    break;
                }
                case 3: {
                    this.m_val = new ExternalTciBooleanValue(this);
                    break;
                }
                case 4: {
                    this.m_val = new ExternalTciCharValue(this);
                    break;
                }
                case 5: {
                    this.m_val = new ExternalTciCStringValue(this);
                    break;
                }
                case 2: {
                    this.m_val = new ExternalTciBStringValue(this);
                    break;
                }
                case 9: {
                    this.m_val = new ExternalTciHStringValue(this);
                    break;
                }
                case 12: {
                    this.m_val = new ExternalTciOStringValue(this);
                    break;
                }
                case 19: {
                    this.m_val = new ExternalTciUCharValue(this);
                    break;
                }
                case 20: {
                    this.m_val = new ExternalTciUStringValue(this);
                    break;
                }
                case 7: {
                    this.m_val = new ExternalTciEnumValue(this);
                    break;
                }
                case 21: {
                    this.m_val = new ExternalTciVerdictValue(this);
                    break;
                }
                case 13: 
                case 16: {
                    this.m_val = new ExternalTciRecordValue(this);
                    break;
                }
                case 1: 
                case 18: {
                    this.m_val = new ExternalTciUnionValue(this);
                    break;
                }
                case 14: 
                case 15: 
                case 17: {
                    this.m_val = new ExternalTciRecordOfValue(this);
                    break;
                }
                case 0: {
                    this.m_val = new ExternalTciAddressValue(this);
                    break;
                }
                case 11: {
                    this.m_val = new ExternalTciObjidValue(this);
                    break;
                }
                default: {
                    this.m_val = new ExternalTciValue(this);
                }
            }
        }
        return this.m_val;
    }

    static void serializeOptionalRef(TciValueRef valRef, ByteArrayOutputStream ms) {
        TciValueRef.writeBool(ms, valRef != null);
        if (valRef != null) {
            valRef.serialize(ms);
        }
    }

    static TciValueRef deserializeOptionalRef(ByteArrayInputStream ms) throws IOException {
        TciValueRef res = null;
        if (TciValueRef.readBool(ms)) {
            res = new TciValueRef();
            res.deserialize(ms);
        }
        return res;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        TciValueRef.writeLong(ms, this.m_nId);
        TciValueRef.writeInt(ms, TciValueRef.toMMTypeClass(this.m_nType));
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        this.m_nId = TciValueRef.readLong(ms);
        this.m_nType = TciValueRef.toTypeClass4_2_2(TciValueRef.readInt(ms));
        Logger.getInstance().writeLine("TciValue reference created; ID " + this.m_nId);
    }

    public static int toMMTypeClass(int n_typeClass) {
        if (n_typeClass == 0) {
            return 0;
        }
        if (n_typeClass == 1) {
            return 1;
        }
        if (n_typeClass == 2) {
            return 2;
        }
        if (n_typeClass == 3) {
            return 3;
        }
        if (n_typeClass == 4) {
            return 4;
        }
        if (n_typeClass == 5) {
            return 5;
        }
        if (n_typeClass == 6) {
            return 6;
        }
        if (n_typeClass == 7) {
            return 7;
        }
        if (n_typeClass == 8) {
            return 8;
        }
        if (n_typeClass == 9) {
            return 9;
        }
        if (n_typeClass == 10) {
            return 10;
        }
        if (n_typeClass == 11) {
            return 11;
        }
        if (n_typeClass == 12) {
            return 12;
        }
        if (n_typeClass == 13) {
            return 13;
        }
        if (n_typeClass == 14) {
            return 14;
        }
        if (n_typeClass == 16) {
            return 15;
        }
        if (n_typeClass == 17) {
            return 16;
        }
        if (n_typeClass == 18) {
            return 17;
        }
        if (n_typeClass == 19) {
            return 18;
        }
        if (n_typeClass == 20) {
            return 19;
        }
        if (n_typeClass == 21) {
            return 20;
        }
        if (n_typeClass == 15) {
            return 21;
        }
        throw new IllegalArgumentException();
    }

    public static int toTypeClass4_2_2(int n_MM_TypeClass) {
        switch (n_MM_TypeClass) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 16;
            }
            case 16: {
                return 17;
            }
            case 17: {
                return 18;
            }
            case 18: {
                return 19;
            }
            case 19: {
                return 20;
            }
            case 20: {
                return 21;
            }
            case 21: {
                return 15;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
        }
        throw new IllegalArgumentException();
    }

    void setValue(ExternalTciValue externalTciValue) {
        this.m_val = externalTciValue;
    }
}

